/*
 * Decompiled with CFR 0.152.
 */
package com.technophobia.webdriver.util;

import com.technophobia.webdriver.substeps.runner.Condition;
import com.technophobia.webdriver.substeps.runner.DriverType;
import com.technophobia.webdriver.substeps.runner.WebdriverSubstepsPropertiesConfiguration;
import com.technophobia.webdriver.util.ElementLocators;
import com.technophobia.webdriver.util.WebDriverBrowserLogs;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverContext {
    private static final Logger logger = LoggerFactory.getLogger(WebDriverContext.class);
    public static final String EXECUTION_CONTEXT_KEY = "_webdriver_context_key";
    private final DriverType driverType;
    private final WebDriver webDriver;
    private final WebDriverBrowserLogs browserLogs;
    private WebElement currentElement = null;
    private boolean failed = false;
    private Map<String, WebElement> elementStash = null;

    public WebDriverContext(DriverType driverType, WebDriver webDriver) {
        this.driverType = driverType;
        this.webDriver = webDriver;
        this.browserLogs = new WebDriverBrowserLogs(webDriver);
    }

    public WebElement getCurrentElement() {
        Assert.assertNotNull((String)"expecting current element not to be null", (Object)this.currentElement);
        return this.currentElement;
    }

    public void setCurrentElement(WebElement currentElement) {
        this.currentElement = currentElement;
    }

    public WebDriver getWebDriver() {
        return this.webDriver;
    }

    public DriverType getDriverType() {
        return this.driverType;
    }

    public void shutdownWebDriver() {
        logger.debug("Shutting WebDriver down");
        if (this.webDriver != null) {
            this.browserLogs.printBrowserLogs();
            this.webDriver.manage().deleteAllCookies();
            this.webDriver.quit();
        }
    }

    public void resetWebDriver() {
        logger.debug("Resetting WebDriver");
        if (this.webDriver != null) {
            this.browserLogs.printBrowserLogs();
            this.webDriver.manage().deleteAllCookies();
        }
    }

    public boolean hasFailed() {
        return this.failed;
    }

    public void setFailed() {
        this.failed = true;
    }

    public WebElement waitForElement(By by) {
        return ElementLocators.waitForElement(by, WebdriverSubstepsPropertiesConfiguration.INSTANCE.defaultTimeout(), this.webDriver);
    }

    public WebElement waitForElement(By by, long timeOutSeconds) {
        return ElementLocators.waitForElement(by, timeOutSeconds, this.webDriver);
    }

    public boolean waitForCondition(Condition condition) {
        return ElementLocators.waitForCondition(condition, this.webDriver);
    }

    public void stashElement(String key, WebElement element) {
        if (this.elementStash == null) {
            this.elementStash = new HashMap<String, WebElement>();
        }
        if (this.elementStash.containsKey(key)) {
            logger.debug("replacing existing object in stash using key: " + key);
        }
        this.elementStash.put(key, element);
    }

    public WebElement getElementFromStash(String key) {
        WebElement elem = this.elementStash != null ? this.elementStash.get(key) : null;
        Assert.assertNotNull((String)("Attempt to retrieve a null element from the stash with key: " + key), (Object)elem);
        return elem;
    }
}

