/*
 * Decompiled with CFR 0.152.
 */
package com.technophobia.webdriver.util;

import java.util.Date;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.Logs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverBrowserLogs {
    private static final Logger logger = LoggerFactory.getLogger(WebDriverBrowserLogs.class);
    private final WebDriver webDriver;

    public WebDriverBrowserLogs(WebDriver webDriver) {
        this.webDriver = webDriver;
    }

    public void printBrowserLogs() {
        Logs logs;
        if (logger.isTraceEnabled() && (logs = this.webDriver.manage().logs()) != null) {
            LogEntries logEntries = logs.get("browser");
            StringBuilder buf = new StringBuilder();
            buf.append("BROWSER LOGS:\n\n");
            for (LogEntry entry : logEntries) {
                buf.append(new Date(entry.getTimestamp()) + " " + entry.getLevel() + " " + entry.getMessage() + "\n");
            }
            logger.trace(buf.toString());
        }
    }
}

