/*
 * Decompiled with CFR 0.152.
 */
package com.technophobia.webdriver.util;

import com.google.common.base.Function;
import com.technophobia.webdriver.substeps.runner.Condition;
import com.technophobia.webdriver.substeps.runner.WebdriverSubstepsPropertiesConfiguration;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementLocators {
    private static final Logger LOG = LoggerFactory.getLogger(ElementLocators.class);
    private static final int timeout = 10;
    static final long polltime = 1000L;

    public static WebElement waitForElement(By by, WebDriver webDriver) {
        return ElementLocators.waitForElement(by, WebdriverSubstepsPropertiesConfiguration.INSTANCE.defaultTimeout(), webDriver);
    }

    public static WebElement waitForElement(final By by, long timeOutSeconds, WebDriver webDriver) {
        WebDriverWait wait = new WebDriverWait(webDriver, timeOutSeconds);
        Function<WebDriver, WebElement> condition2 = new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                return driver.findElement(by);
            }
        };
        return ElementLocators.waitUntil(wait, condition2, webDriver);
    }

    private static WebElement waitUntil(WebDriverWait wait, Function<WebDriver, WebElement> condition, WebDriver webDriver) {
        WebElement elem = null;
        try {
            elem = (WebElement)wait.until(condition);
        }
        catch (TimeoutException e) {
            LOG.debug("timed out page src:\n" + webDriver.getPageSource());
        }
        return elem;
    }

    public static boolean waitForCondition(Condition condition, WebDriver webDriver) {
        int count = 0;
        while (!condition.conditionMet()) {
            ++count;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (count != 10) continue;
            return false;
        }
        return true;
    }
}

