/*
 * Decompiled with CFR 0.152.
 */
package com.technophobia.webdriver.substeps.runner;

import com.technophobia.substeps.model.Configuration;
import com.technophobia.webdriver.substeps.runner.DefaultDriverType;
import com.technophobia.webdriver.substeps.runner.WebDriverFactory;
import com.technophobia.webdriver.substeps.runner.WebdriverSubstepsConfiguration;
import java.io.File;
import java.net.URL;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum WebdriverSubstepsPropertiesConfiguration implements WebdriverSubstepsConfiguration
{
    INSTANCE;

    private final Logger LOG = LoggerFactory.getLogger(WebdriverSubstepsPropertiesConfiguration.class);
    private final Class<? extends WebDriverFactory> webdriverFactoryClass;
    private final String baseUrl;
    private final String driverLocale;
    private final boolean reuseWebdriver;
    private final String htmlUnitProxyHost;
    private final String chromeDriverPath;
    private final boolean shutdownWebdriver;
    private final boolean htmlunitDisableJs;
    private final Integer htmlUnitProxyPort;
    private final DefaultDriverType driverType;
    private final boolean visualWebdriverCloseOnFail;
    private final String networkProxyHost;
    private final int networkProxyPort;
    private long defaultWebDriverTimeoutSecs;

    private WebdriverSubstepsPropertiesConfiguration() {
        URL defaultURL = this.getClass().getResource("/default-webdriver-substeps.properties");
        Assert.assertNotNull((Object)defaultURL);
        Configuration.INSTANCE.addDefaultProperties(defaultURL, "default-webdriver");
        this.baseUrl = this.determineBaseURL(Configuration.INSTANCE.getString("base.url"));
        this.driverType = DefaultDriverType.valueOf(Configuration.INSTANCE.getString("driver.type").toUpperCase());
        this.driverLocale = Configuration.INSTANCE.getString("webdriver.locale");
        this.shutdownWebdriver = Configuration.INSTANCE.getBoolean("webdriver.shutdown");
        this.visualWebdriverCloseOnFail = Configuration.INSTANCE.getBoolean("visual.webdriver.close.on.fail");
        this.reuseWebdriver = Configuration.INSTANCE.getBoolean("webdriver.reuse");
        this.defaultWebDriverTimeoutSecs = Configuration.INSTANCE.getInt("default.webdriver.timeout.secs");
        this.htmlunitDisableJs = Configuration.INSTANCE.getBoolean("htmlunit.disable.javascript");
        this.htmlUnitProxyHost = Configuration.INSTANCE.getString("htmlunit.proxy.host");
        this.htmlUnitProxyPort = Configuration.INSTANCE.getInt("htmlunit.proxy.port");
        this.networkProxyHost = Configuration.INSTANCE.getString("network.proxy.host");
        this.networkProxyPort = Configuration.INSTANCE.getInt("network.proxy.port");
        this.chromeDriverPath = Configuration.INSTANCE.getString("chromedriver.path");
        try {
            this.webdriverFactoryClass = Class.forName(Configuration.INSTANCE.getString("webdriver.factory.class")).asSubclass(WebDriverFactory.class);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("'webdriver.factory.class' is invalid.", ex);
        }
        this.LOG.info("Using properties:\n" + Configuration.INSTANCE.getConfigurationInfo());
    }

    @Override
    public String baseURL() {
        return this.baseUrl;
    }

    @Override
    public DefaultDriverType driverType() {
        return this.driverType;
    }

    @Override
    public String driverLocale() {
        return this.driverLocale;
    }

    @Override
    public boolean shutDownWebdriver() {
        return this.shutdownWebdriver;
    }

    @Override
    public boolean isJavascriptDisabledWithHTMLUnit() {
        return this.htmlunitDisableJs;
    }

    @Override
    public boolean closeVisualWebDriveronFail() {
        return this.visualWebdriverCloseOnFail;
    }

    @Override
    public boolean reuseWebDriver() {
        return this.reuseWebdriver;
    }

    @Override
    public long defaultTimeout() {
        return this.defaultWebDriverTimeoutSecs;
    }

    @Override
    public String getHtmlUnitProxyHost() {
        return this.htmlUnitProxyHost;
    }

    @Override
    public Integer getHtmlUnitProxyPort() {
        return this.htmlUnitProxyPort;
    }

    @Override
    public Class<? extends WebDriverFactory> getWebDriverFactoryClass() {
        return this.webdriverFactoryClass;
    }

    @Override
    public String getNetworkProxyHost() {
        return this.networkProxyHost;
    }

    @Override
    public int getNetworkProxyPort() {
        return this.networkProxyPort;
    }

    private String determineBaseURL(String baseUrlProperty) {
        String property = this.removeTrailingSlash(baseUrlProperty);
        String resolvedBaseUrl = !property.startsWith("http") && !property.startsWith("file://") ? this.removeTrailingSlash(new File(property).toURI().toString()) : property;
        return resolvedBaseUrl;
    }

    private String removeTrailingSlash(String string) {
        if (string.endsWith("/")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    @Override
    public String getChromeDriverPath() {
        return this.chromeDriverPath;
    }
}

