/*
 * Decompiled with CFR 0.152.
 */
package com.technophobia.webdriver.substeps.runner;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebClient;
import com.technophobia.webdriver.substeps.runner.DriverType;
import com.technophobia.webdriver.substeps.runner.WebDriverFactory;
import com.technophobia.webdriver.substeps.runner.WebdriverSubstepsConfiguration;
import com.technophobia.webdriver.substeps.runner.WebdriverSubstepsPropertiesConfiguration;
import com.technophobia.webdriver.util.WebDriverContext;
import java.lang.reflect.Field;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebDriverFactory
implements WebDriverFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultWebDriverFactory.class);
    private final WebdriverSubstepsConfiguration configuration;

    public DefaultWebDriverFactory() {
        this(WebdriverSubstepsPropertiesConfiguration.INSTANCE);
    }

    public DefaultWebDriverFactory(WebdriverSubstepsConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public WebDriver createWebDriver() {
        FirefoxDriver webDriver;
        switch (this.configuration.driverType()) {
            case FIREFOX: {
                DesiredCapabilities firefoxCapabilities = DesiredCapabilities.firefox();
                this.setNetworkCapabilities(firefoxCapabilities);
                this.setLoggingPreferences(firefoxCapabilities);
                webDriver = new FirefoxDriver((Capabilities)firefoxCapabilities);
                break;
            }
            case HTMLUNIT: {
                String proxyHost;
                HtmlUnitDriver htmlUnitDriver = new HtmlUnitDriver(BrowserVersion.FIREFOX_38);
                htmlUnitDriver.setJavascriptEnabled(!this.configuration.isJavascriptDisabledWithHTMLUnit());
                String htmlunitProxyHost = this.configuration.getHtmlUnitProxyHost();
                if (StringUtils.isNotEmpty((CharSequence)htmlunitProxyHost)) {
                    int htmlunitProxyPort = this.configuration.getHtmlUnitProxyPort();
                    htmlUnitDriver.setProxy(htmlunitProxyHost, htmlunitProxyPort);
                }
                if (StringUtils.isNotEmpty((CharSequence)(proxyHost = this.configuration.getNetworkProxyHost()))) {
                    int proxyPort = this.configuration.getNetworkProxyPort();
                    htmlUnitDriver.setProxy(proxyHost, proxyPort);
                }
                this.setDriverLocale((WebDriver)htmlUnitDriver);
                webDriver = htmlUnitDriver;
                break;
            }
            case CHROME: {
                String preset = System.getProperty("webdriver.chrome.driver");
                if (preset == null) {
                    String driverPath = this.configuration.getChromeDriverPath();
                    Assert.assertNotNull((String)"Chromedriver path not set as a -Dwebdriver.chrome.driver parameter or in config", (Object)driverPath);
                    System.setProperty("webdriver.chrome.driver", driverPath);
                }
                DesiredCapabilities chromeCapabilities = DesiredCapabilities.chrome();
                this.setNetworkCapabilities(chromeCapabilities);
                this.setLoggingPreferences(chromeCapabilities);
                webDriver = new ChromeDriver((Capabilities)chromeCapabilities);
                break;
            }
            case IE: {
                DesiredCapabilities ieCapabilities = DesiredCapabilities.internetExplorer();
                ieCapabilities.setCapability("ignoreProtectedModeSettings", true);
                LOG.warn("Using IE Webdriver with IGNORING SECURITY DOMAIN");
                this.setNetworkCapabilities(ieCapabilities);
                webDriver = new InternetExplorerDriver((Capabilities)ieCapabilities);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown driver type " + this.configuration.driverType());
            }
        }
        webDriver.manage().window().maximize();
        return webDriver;
    }

    private void setLoggingPreferences(DesiredCapabilities chromeCapabilities) {
        LoggingPreferences logPrefs = new LoggingPreferences();
        logPrefs.enable("browser", Level.ALL);
        chromeCapabilities.setCapability("loggingPrefs", (Object)logPrefs);
    }

    private void setNetworkCapabilities(DesiredCapabilities capabilities) {
        String proxyHost = this.configuration.getNetworkProxyHost();
        if (StringUtils.isNotEmpty((CharSequence)proxyHost)) {
            int proxyPort = this.configuration.getNetworkProxyPort();
            String proxyHostAndPort = proxyHost + ":" + proxyPort;
            Proxy proxy = new Proxy();
            proxy.setHttpProxy(proxyHostAndPort).setFtpProxy(proxyHostAndPort).setSslProxy(proxyHostAndPort);
            capabilities.setCapability("proxy", (Object)proxy);
            LOG.info("Proxy set to {}", (Object)proxyHostAndPort);
        }
    }

    @Override
    public DriverType driverType() {
        return this.configuration.driverType();
    }

    private void setDriverLocale(WebDriver driver) {
        try {
            Field field = driver.getClass().getDeclaredField("webClient");
            if (field != null) {
                boolean original = field.isAccessible();
                field.setAccessible(true);
                WebClient webClient = (WebClient)field.get(driver);
                if (webClient != null) {
                    webClient.addRequestHeader("Accept-Language", "en-gb");
                }
                field.setAccessible(original);
            } else {
                Assert.fail((String)"Failed to get webclient field to set accept language");
            }
        }
        catch (IllegalAccessException ex) {
            LOG.warn(ex.getMessage());
        }
        catch (SecurityException e) {
            LOG.warn(e.getMessage());
        }
        catch (NoSuchFieldException e) {
            LOG.warn(e.getMessage());
        }
    }

    @Override
    public void shutdownWebDriver(WebDriverContext webDriverContext) {
        LOG.debug("Shutting WebDriver down");
        WebDriver webDriver = webDriverContext.getWebDriver();
        if (webDriver != null) {
            webDriver.manage().deleteAllCookies();
            webDriver.quit();
        }
    }

    @Override
    public boolean resetWebDriver(WebDriverContext webDriverContext) {
        LOG.debug("Resetting WebDriver");
        WebDriver webDriver = webDriverContext.getWebDriver();
        if (webDriver != null) {
            webDriver.manage().deleteAllCookies();
        }
        return true;
    }
}

