/*
 * Decompiled with CFR 0.152.
 */
package com.technophobia.webdriver.substeps.runner;

import com.technophobia.substeps.model.Scope;
import com.technophobia.substeps.runner.ExecutionContext;
import com.technophobia.substeps.runner.ExecutionContextSupplier;
import com.technophobia.substeps.runner.IExecutionListener;
import com.technophobia.substeps.runner.INotificationDistributor;
import com.technophobia.substeps.runner.MutableSupplier;
import com.technophobia.substeps.runner.setupteardown.Annotations;
import com.technophobia.webdriver.substeps.runner.TestFailureListener;
import com.technophobia.webdriver.substeps.runner.WebDriverFactory;
import com.technophobia.webdriver.substeps.runner.WebdriverSubstepsConfiguration;
import com.technophobia.webdriver.substeps.runner.WebdriverSubstepsPropertiesConfiguration;
import com.technophobia.webdriver.util.WebDriverContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecutionSetupTearDown {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExecutionSetupTearDown.class);
    private final MutableSupplier<WebDriverContext> webDriverContextSupplier = new ExecutionContextSupplier(Scope.SUITE, "_webdriver_context_key");
    private final MutableSupplier<WebDriverFactory> webDriverFactorySupplier = new ExecutionContextSupplier(Scope.SUITE, "webDriverFactory");
    private final WebdriverSubstepsConfiguration configuration;
    private long startTimeMillis;

    public DefaultExecutionSetupTearDown() {
        this(WebdriverSubstepsPropertiesConfiguration.INSTANCE);
    }

    public DefaultExecutionSetupTearDown(WebdriverSubstepsConfiguration configuration) {
        this.configuration = configuration;
    }

    @Annotations.BeforeAllFeatures
    public final void beforeAllFeaturesSetup() {
        INotificationDistributor notifier = (INotificationDistributor)ExecutionContext.get((Scope)Scope.SUITE, (String)"notifier");
        notifier.addListener((IExecutionListener)new TestFailureListener(this.webDriverContextSupplier));
        logger.info("beforeAllTestsSetup");
        String env = System.getProperty("environment");
        if (env == null) {
            logger.warn("\n\n\n****** NO ENVIRONMENT SET DEFAULTING TO LOCALHOST ADD -Denvironment=mycomputer\" TO OVERRIDE******* \n\n\n\n");
            env = "localhost";
            System.setProperty("environment", env);
        }
        logger.info("env prop: " + env);
        WebDriverFactory factory = this.createWebDriverFactory();
        this.webDriverFactorySupplier.set((Object)factory);
    }

    @Annotations.BeforeEveryScenario
    public final void basePreScenarioSetup() {
        this.startTimeMillis = System.currentTimeMillis();
        WebDriverContext webDriverContext = (WebDriverContext)this.webDriverContextSupplier.get();
        boolean createNewWebDriver = this.shouldStartup(webDriverContext);
        if (createNewWebDriver) {
            WebDriverFactory factory = (WebDriverFactory)this.webDriverFactorySupplier.get();
            this.webDriverContextSupplier.set((Object)new WebDriverContext(factory.driverType(), factory.createWebDriver()));
        }
    }

    @Annotations.AfterEveryScenario
    public final void basePostScenariotearDown() {
        long ticks;
        WebDriverContext webDriverContext = (WebDriverContext)this.webDriverContextSupplier.get();
        if (webDriverContext != null) {
            boolean doShutdown = this.shouldShutdown(webDriverContext);
            WebDriverFactory factory = (WebDriverFactory)this.webDriverFactorySupplier.get();
            if (doShutdown) {
                factory.shutdownWebDriver(webDriverContext);
                this.webDriverContextSupplier.set(null);
            } else if (!factory.resetWebDriver(webDriverContext)) {
                factory.shutdownWebDriver(webDriverContext);
                this.webDriverContextSupplier.set(null);
            }
        }
        if ((ticks = (System.currentTimeMillis() - this.startTimeMillis) / 1000L) > 30L) {
            logger.warn(String.format("Test scenario took %s seconds", ticks));
        } else {
            logger.info(String.format("Test scenario took %s seconds", ticks));
        }
    }

    private boolean shouldShutdown(WebDriverContext webDriverContext) {
        if (webDriverContext != null) {
            logger.debug("webDriverContextSupplier.get().hasFailed(): {}", (Object)webDriverContext.hasFailed());
            logger.debug("driverType().isVisual(): {}", (Object)webDriverContext.getDriverType().isVisual());
        }
        logger.debug("WebdriverSubstepsPropertiesConfiguration.closeVisualWebDriveronFail(): {}", (Object)this.configuration.closeVisualWebDriveronFail());
        logger.debug("WebdriverSubstepsPropertiesConfiguration.reuseWebDriver(): {}", (Object)this.configuration.reuseWebDriver());
        boolean doShutDown = true;
        if (!this.configuration.shutDownWebdriver() && (this.failedIsVisualButShouldNotClose(webDriverContext) || this.configuration.reuseWebDriver())) {
            doShutDown = false;
        }
        return doShutDown;
    }

    private boolean shouldStartup(WebDriverContext webDriverContext) {
        if (webDriverContext != null) {
            logger.debug("webDriverContextSupplier.get().hasFailed(): {}", (Object)webDriverContext.hasFailed());
            logger.debug("driverType().isVisual(): {}", (Object)webDriverContext.getDriverType().isVisual());
        }
        logger.debug("WebdriverSubstepsPropertiesConfiguration.closeVisualWebDriveronFail(): {}", (Object)this.configuration.closeVisualWebDriveronFail());
        logger.debug("WebdriverSubstepsPropertiesConfiguration.reuseWebDriver(): {}", (Object)this.configuration.reuseWebDriver());
        boolean doStartup = true;
        if (webDriverContext != null && !this.configuration.shutDownWebdriver() && !this.failedIsVisualButShouldNotClose(webDriverContext) && this.configuration.reuseWebDriver()) {
            doStartup = false;
        }
        return doStartup;
    }

    private boolean failedIsVisualButShouldNotClose(WebDriverContext webDriverContext) {
        boolean shouldNotClose = false;
        if (!this.configuration.closeVisualWebDriveronFail() && webDriverContext != null && webDriverContext.getDriverType().isVisual()) {
            shouldNotClose = webDriverContext.hasFailed();
        }
        return shouldNotClose;
    }

    private WebDriverFactory createWebDriverFactory() {
        Class<? extends WebDriverFactory> webDriverFactoryClass = this.configuration.getWebDriverFactoryClass();
        logger.debug("Creating WebDriverFactory of type [{}]", (Object)webDriverFactoryClass.getName());
        try {
            return webDriverFactoryClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException(String.format("Failed to create WebDriverFactory %s.", webDriverFactoryClass.getName()), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(String.format("Failed to create WebDriverFactory %s.", webDriverFactoryClass.getName()), ex);
        }
    }
}

