/*
 * Decompiled with CFR 0.152.
 */
package com.technophobia.webdriver.substeps.impl;

import com.technophobia.substeps.model.SubSteps;
import com.technophobia.substeps.model.parameter.IntegerConverter;
import com.technophobia.webdriver.substeps.impl.AbstractWebDriverSubStepImplementations;
import com.technophobia.webdriver.substeps.impl.AssertionWebDriverSubStepImplementations;
import com.technophobia.webdriver.substeps.runner.DefaultExecutionSetupTearDown;
import com.technophobia.webdriver.util.WebDriverSubstepsBy;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.text.IsEqualIgnoringCase;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@SubSteps.StepImplementations(requiredInitialisationClasses={DefaultExecutionSetupTearDown.class})
public class TableSubStepImplementations
extends AbstractWebDriverSubStepImplementations {
    private static final String TABLE_ROW_KEY = "_tr_stash_key";

    @SubSteps.Step(value="FindTableBodyRow row ([^\"]*)")
    public WebElement findTableBodyRow(@SubSteps.StepParameter(converter=IntegerConverter.class) Integer row) {
        WebElement currentElem = this.webDriverContext().getCurrentElement();
        AssertionWebDriverSubStepImplementations.assertElementIs(currentElem, "table");
        WebElement tbody = this.getResultsTableBodyElement(currentElem);
        WebElement rowElement = this.getTableRow(tbody, row);
        Assert.assertNotNull((String)"expecting a table row element", (Object)rowElement);
        this.webDriverContext().setCurrentElement(rowElement);
        return rowElement;
    }

    @SubSteps.Step(value="AssertTableValue column ([^\"]*), row ([^\"]*) contains text \"([^\"]*)\"")
    public void assertTableValue(@SubSteps.StepParameter(converter=IntegerConverter.class) Integer column, @SubSteps.StepParameter(converter=IntegerConverter.class) Integer row, String text) {
        WebElement currentElem = this.webDriverContext().getCurrentElement();
        AssertionWebDriverSubStepImplementations.assertElementIs(currentElem, "table");
        WebElement tbody = this.getResultsTableBodyElement(currentElem);
        String cellText = this.getValueInResultsTable(tbody, column, row);
        Assert.assertNotNull((String)"expecting some cell text", (Object)cellText);
        Assert.assertTrue((String)("expecting cell text to contain: " + text + " actual: " + cellText), (boolean)cellText.contains(text));
    }

    private WebElement getResultsTableBodyElement(WebElement tableElement) {
        Assert.assertNotNull((String)"expecting a tableElement", (Object)tableElement);
        List tbodyElems = tableElement.findElements(By.tagName((String)"tbody"));
        Assert.assertNotNull((String)"expecting th row elems", (Object)tbodyElems);
        Assert.assertThat((String)"expecting count of 1", (Object)tbodyElems.size(), (Matcher)CoreMatchers.is((Object)1));
        WebElement tbody = (WebElement)tbodyElems.get(0);
        Assert.assertNotNull((String)"expecting tbody elem", (Object)tbody);
        return tbody;
    }

    private WebElement getTableRow(WebElement tbody, int row) {
        List rowElements = tbody.findElements(By.tagName((String)"tr"));
        Assert.assertNotNull((String)"expecting th row elems", (Object)rowElements);
        Assert.assertTrue((String)("expecting more than " + row + " row in the table"), (rowElements.size() >= row ? 1 : 0) != 0);
        WebElement rowElement = (WebElement)rowElements.get(row - 1);
        Assert.assertNotNull((String)("expecting a tr at tbody idx: " + (row - 1)), (Object)rowElement);
        return rowElement;
    }

    public String getValueInResultsTable(WebElement tbody, int col, int row) {
        WebElement rowElement = this.getTableRow(tbody, row);
        List columnElements = rowElement.findElements(By.tagName((String)"td"));
        Assert.assertNotNull((String)"expecting columnElements", (Object)columnElements);
        Assert.assertTrue((String)("expecting more than " + col + " columns in the table, got: " + columnElements.size()), (columnElements.size() >= col ? 1 : 0) != 0);
        WebElement tdElem = (WebElement)columnElements.get(col - 1);
        Assert.assertNotNull((String)("expecting a td at column: " + col), (Object)tdElem);
        return tdElem.getText();
    }

    @SubSteps.Step(value="FindTableRowWithColumnsThatContainText \\[(.*)\\]")
    public void findRowInTableWithText(String columnText) {
        WebElement currentElement = this.webDriverContext().getCurrentElement();
        Assert.assertThat((String)"expecting the current element to be a table", (Object)currentElement.getTagName(), (Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"table"));
        String[] columnValues = columnText.split(",");
        ArrayList<String> columnValList = new ArrayList<String>();
        for (String s : columnValues) {
            columnValList.add(s.replaceAll("\"", "").trim());
        }
        List tableRows = currentElement.findElements(By.tagName((String)"tr"));
        ArrayList<WebElement> matchingRows = null;
        for (WebElement row : tableRows) {
            List tableCells = row.findElements(By.tagName((String)"td"));
            int lookingForIdx = 0;
            boolean found = false;
            for (WebElement td : tableCells) {
                if (!td.getText().contains((CharSequence)columnValList.get(lookingForIdx)) || ++lookingForIdx < columnValList.size()) continue;
                found = true;
                break;
            }
            if (!found) continue;
            if (matchingRows == null) {
                matchingRows = new ArrayList<WebElement>();
            }
            matchingRows.add(row);
        }
        Assert.assertNotNull((String)("Didn't find any rows with values: [" + columnText + "]"), matchingRows);
        Assert.assertThat((String)("Found too many rows that match values: [" + columnText + "]"), (Object)matchingRows.size(), (Matcher)CoreMatchers.is((Object)1));
        this.webDriverContext().stashElement(TABLE_ROW_KEY, (WebElement)matchingRows.get(0));
    }

    @SubSteps.Step(value="FindElementInRow ByTagAndAttributes tag=\"?([^\"]*)\"? attributes=\\[(.*)\\]")
    public void findLinkInRowByTagAndAttributes(String tag, String attributeString) {
        WebDriverSubstepsBy.ByTagAndAttributes by = WebDriverSubstepsBy.ByTagAndAttributes(tag, attributeString);
        this.findElementInRowBy(by);
    }

    @SubSteps.Step(value="FindElementInRow linkText=\"([^\"]*)\"")
    public void findLinkInRow(String linkText) {
        By by = By.linkText((String)linkText);
        this.findElementInRowBy(by);
    }

    private WebElement findElementInRowBy(By by) {
        this.webDriverContext().setCurrentElement(null);
        WebElement row = this.webDriverContext().getElementFromStash(TABLE_ROW_KEY);
        Assert.assertThat((String)"expecting the current element to be a table", (Object)row.getTagName(), (Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"tr"));
        List tableCells = row.findElements(By.tagName((String)"td"));
        ArrayList matchingElements = null;
        for (WebElement e : tableCells) {
            List foundElements = e.findElements(by);
            if (foundElements == null || foundElements.isEmpty()) continue;
            if (matchingElements == null) {
                matchingElements = new ArrayList();
            }
            matchingElements.addAll(foundElements);
        }
        Assert.assertNotNull((String)"expecting to have found some elements", matchingElements);
        Assert.assertThat((String)"Found too many elements in the row", (Object)matchingElements.size(), (Matcher)CoreMatchers.is((Object)1));
        WebElement current = (WebElement)matchingElements.get(0);
        this.webDriverContext().setCurrentElement(current);
        return current;
    }
}

