/*
 * Decompiled with CFR 0.152.
 */
package com.technophobia.webdriver.substeps.impl;

import com.technophobia.webdriver.util.WebDriverContext;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public abstract class MatchingElementResultHandler {
    public static final AtLeastOneElementImpl AtLeastOneElement = new AtLeastOneElementImpl();
    public static final ExactlyOneElementImpl ExactlyOneElement = new ExactlyOneElementImpl();
    public static final NoneFailingOneElementImpl NoneFailingOneElement = new NoneFailingOneElementImpl();

    abstract WebElement checkMatchingElements(List<WebElement> var1, String var2);

    public WebElement processResults(WebDriverContext ctx, By by, String msg) {
        WebElement rtn = null;
        List matchingElems = ctx.getWebDriver().findElements(by);
        ArrayList<WebElement> results = new ArrayList<WebElement>();
        if (matchingElems == null || matchingElems.isEmpty()) {
            WebElement elementWaitedFor = ctx.waitForElement(by);
            results.add(elementWaitedFor);
        } else {
            results.addAll(matchingElems);
        }
        rtn = this.checkMatchingElements(results, msg);
        return rtn;
    }

    public static WebElement checkForOneMatchingElement(String msg, List<WebElement> matchingElems) {
        WebElement rtn = null;
        if (matchingElems != null && matchingElems.size() > 1) {
            Assert.fail((String)("Found " + matchingElems.size() + " elements that meet this criteria, expecting only one"));
        } else if (matchingElems != null) {
            rtn = matchingElems.get(0);
        }
        Assert.assertNotNull((String)msg, rtn);
        return rtn;
    }

    public static class NthElement
    extends MatchingElementResultHandler {
        int idx;

        NthElement(int n) {
            Assert.assertThat((Object)n, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            this.idx = n - 1;
        }

        @Override
        WebElement checkMatchingElements(List<WebElement> matchingElems, String msg) {
            WebElement rtn = null;
            if (matchingElems != null && !matchingElems.isEmpty() && matchingElems.size() > this.idx) {
                rtn = matchingElems.get(this.idx);
            }
            Assert.assertNotNull((String)msg, rtn);
            return rtn;
        }
    }

    public static class AtLeastOneElementImpl
    extends MatchingElementResultHandler {
        @Override
        WebElement checkMatchingElements(List<WebElement> matchingElems, String msg) {
            WebElement rtn = null;
            if (matchingElems != null && !matchingElems.isEmpty()) {
                rtn = matchingElems.get(0);
            }
            Assert.assertNotNull((String)msg, rtn);
            return rtn;
        }
    }

    public static class NoneFailingOneElementImpl
    extends MatchingElementResultHandler {
        @Override
        WebElement checkMatchingElements(List<WebElement> matchingElems, String msg) {
            WebElement rtn = null;
            if (matchingElems != null && matchingElems.size() > 1) {
                Assert.fail((String)("Found " + matchingElems.size() + " elements that meet this criteria, expecting only one"));
            } else if (matchingElems != null) {
                rtn = matchingElems.get(0);
            }
            return rtn;
        }
    }

    public static class ExactlyOneElementImpl
    extends MatchingElementResultHandler {
        @Override
        WebElement checkMatchingElements(List<WebElement> matchingElems, String msg) {
            return ExactlyOneElementImpl.checkForOneMatchingElement(msg, matchingElems);
        }
    }
}

