/*
 * Decompiled with CFR 0.152.
 */
package com.technophobia.webdriver.substeps.impl;

import com.technophobia.substeps.model.SubSteps;
import com.technophobia.substeps.model.parameter.BooleanConverter;
import com.technophobia.webdriver.substeps.impl.AbstractWebDriverSubStepImplementations;
import com.technophobia.webdriver.substeps.impl.ActionWebDriverSubStepImplementations;
import com.technophobia.webdriver.substeps.impl.AssertionWebDriverSubStepImplementations;
import com.technophobia.webdriver.substeps.impl.FinderWebDriverSubStepImplementations;
import com.technophobia.webdriver.substeps.runner.DefaultExecutionSetupTearDown;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SubSteps.StepImplementations(requiredInitialisationClasses={DefaultExecutionSetupTearDown.class})
public class FormWebDriverSubStepImplementations
extends AbstractWebDriverSubStepImplementations {
    private static final Logger logger = LoggerFactory.getLogger(FormWebDriverSubStepImplementations.class);
    private final FinderWebDriverSubStepImplementations locator = new FinderWebDriverSubStepImplementations();
    private final ActionWebDriverSubStepImplementations actions = new ActionWebDriverSubStepImplementations();

    @SubSteps.Step(value="Submit")
    public void submit() {
        logger.debug("About to submit the form");
        this.webDriverContext().getCurrentElement().submit();
    }

    @SubSteps.Step(value="SendKeys \"([^\"]*)\"")
    public void sendKeys(String value) {
        logger.debug("About to send keys " + value + " to the current element");
        this.webDriverContext().getCurrentElement().sendKeys(new CharSequence[]{value});
    }

    @SubSteps.Step(value="SendKey Key\\.(.+)")
    public void sendKey(String key) {
        logger.debug("About to send key " + key + " to the current element");
        this.webDriverContext().getCurrentElement().sendKeys(new CharSequence[]{Keys.valueOf((String)key)});
    }

    @SubSteps.Step(value="ClearAndSendKeys \"([^\"]*)\" to id ([^\"]*)")
    public void sendKeysById(String value, String id) {
        logger.debug("About to send keys" + value + " to item with id " + id);
        this.locator.findById(id);
        this.clearAndSendKeys(value);
    }

    @SubSteps.Step(value="ClearAndSendKeys \"([^\"]*)\"")
    public void clearAndSendKeys(String value) {
        logger.debug("About to clear the current element and send the keys " + value);
        this.webDriverContext().getCurrentElement().clear();
        this.webDriverContext().getCurrentElement().sendKeys(new CharSequence[]{value});
    }

    @SubSteps.Step(value="ChooseOption \"([^\"]*)\" in id ([^\"]*)")
    public void selectValueInId(String value, String id) {
        logger.debug("About to choose option " + value + " in select box with id " + id);
        WebElement selectElement = this.locator.findById(id);
        this.chooseOptionByTextInSelect(value, selectElement);
    }

    public void chooseOptionByTextInSelect(String value, WebElement selectElement) {
        Select select = new Select(selectElement);
        select.selectByVisibleText(value);
        Assert.assertTrue((String)"expected value is not selected", (boolean)select.getFirstSelectedOption().isSelected());
        Assert.assertThat((String)"expected value is not selected", (Object)value, (Matcher)CoreMatchers.is((Object)select.getFirstSelectedOption().getText()));
    }

    @SubSteps.Step(value="ChooseOption \"([^\"]*)\" in current element")
    public void selectValueInCurrentElement(String value) {
        this.actions.click();
        boolean found = false;
        List options = this.webDriverContext().getCurrentElement().findElements(By.tagName((String)"option"));
        for (WebElement e : options) {
            if (!e.getText().equalsIgnoreCase(value)) continue;
            e.click();
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException("failed to locate option in select");
        }
    }

    @SubSteps.Step(value="AssertSelect id=\"([^\"]*)\" text=\"([^\"]*)\" is currently selected")
    public void assertOptionIsSelected(String id, String value) {
        logger.debug("Asserting select box with id " + id + " has option " + value + " selected");
        WebElement select = this.locator.findById(id);
        List<WebElement> options = this.getOptions(select);
        for (WebElement option : options) {
            if (!option.getText().equals(value)) continue;
            Assert.assertTrue((String)("option text: " + value + "is not selected"), (boolean)option.isSelected());
            break;
        }
    }

    @SubSteps.Step(value="AssertSelect id=\"([^\"]*)\" text=\"([^\"]*)\" is not currently selected")
    public void assertOptionIsNotSelected(String id, String value) {
        logger.debug("Asserting select box with id " + id + " has option " + value + " not selected");
        WebElement select = this.locator.findById(id);
        List<WebElement> options = this.getOptions(select);
        for (WebElement option : options) {
            if (!option.getText().equals(value)) continue;
            Assert.assertFalse((boolean)option.isSelected());
            break;
        }
    }

    @Deprecated
    @SubSteps.Step(value="SetRadioButton name =([^\"]*), value =([^\"]*), checked =([^\"]*)")
    public void setRadioButtonValue(String name, String value, String checked) {
        throw new IllegalStateException("change code to use SetRadioButton checked= true/false instead");
    }

    @SubSteps.Step(value="SetRadioButton checked=([^\"]*)")
    public void setRadioButtonChecked(String checked) {
        WebElement currentElem = this.webDriverContext().getCurrentElement();
        AssertionWebDriverSubStepImplementations.assertElementIs(currentElem, "input", "radio");
        boolean val = Boolean.parseBoolean(checked.trim());
        this.setCheckboxValue(currentElem, val);
    }

    @SubSteps.Step(value="SetCheckedBox checked=([^\"]*)")
    public void setSetCheckedBoxChecked(String checked) {
        WebElement currentElem = this.webDriverContext().getCurrentElement();
        AssertionWebDriverSubStepImplementations.assertElementIs(currentElem, "input", "checkbox");
        boolean val = Boolean.parseBoolean(checked.trim());
        this.setCheckboxValue(currentElem, val);
    }

    @Deprecated
    @SubSteps.Step(value="SetRadioButton name=\"([^\"]*)\", text=\"([^\"]*)\"")
    public void setRadioButton(String name, String text) {
        throw new IllegalStateException("change code to use SetRadioButton checked=true / false instead");
    }

    @Deprecated
    @SubSteps.Step(value="AssertRadioButton name=\"([^\"]*)\", text=\"([^\"]*)\", checked=\"([^\"]*)\"")
    public void assertRadioButton(String name, String text, @SubSteps.StepParameter(converter=BooleanConverter.class) Boolean checked) {
        throw new IllegalStateException("change code to use AssertRadioButton checked= true/false instead");
    }

    @Deprecated
    @SubSteps.Step(value="SetCheckBox name=\"([^\"]*)\", checked=([^\"]*)")
    public void setSetCheckBox(String name, String checked) {
        throw new IllegalStateException("change code to use SetCheckedBox checked= true/false instead");
    }

    protected void setCheckboxValue(WebElement checkboxField, boolean value) {
        logger.debug("About to set checkbox " + checkboxField + "to " + (value ? "checked" : "not checked"));
        if (checkboxField.isSelected() && !value) {
            checkboxField.click();
        } else if (!checkboxField.isSelected() && value) {
            checkboxField.click();
        }
    }

    private List<WebElement> getOptions(WebElement select) {
        return select.findElements(By.tagName((String)"option"));
    }
}

