/*
 * Decompiled with CFR 0.152.
 */
package com.technophobia.webdriver.substeps.impl;

import com.technophobia.substeps.model.SubSteps;
import com.technophobia.substeps.model.parameter.IntegerConverter;
import com.technophobia.webdriver.substeps.impl.AbstractWebDriverSubStepImplementations;
import com.technophobia.webdriver.substeps.impl.MatchingElementResultHandler;
import com.technophobia.webdriver.substeps.runner.DefaultExecutionSetupTearDown;
import com.technophobia.webdriver.util.WebDriverSubstepsBy;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ByChained;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SubSteps.StepImplementations(requiredInitialisationClasses={DefaultExecutionSetupTearDown.class})
public class FinderWebDriverSubStepImplementations
extends AbstractWebDriverSubStepImplementations {
    private static final Logger logger = LoggerFactory.getLogger(FinderWebDriverSubStepImplementations.class);

    @SubSteps.Step(value="FindById ([^\"]*)")
    public WebElement findById(String id) {
        logger.debug("Looking for item with id " + id);
        this.webDriverContext().setCurrentElement(null);
        WebElement elem = this.webDriverContext().waitForElement(By.id((String)id));
        Assert.assertNotNull((String)("expecting an element with id " + id), (Object)elem);
        this.webDriverContext().setCurrentElement(elem);
        return elem;
    }

    @SubSteps.Step(value="FindByIdTimeout ([^\"]*) timeout = ([^\"]*) secs")
    public WebElement findById(String id, String timeout) {
        logger.debug("Looking for item with id " + id + "within " + timeout + " seconds");
        long t = Long.parseLong(timeout);
        this.webDriverContext().setCurrentElement(null);
        WebElement elem = this.webDriverContext().waitForElement(By.id((String)id), t);
        Assert.assertNotNull((String)("expecting an element with id " + id), (Object)elem);
        this.webDriverContext().setCurrentElement(elem);
        return elem;
    }

    @SubSteps.Step(value="FindByXpath ([^\"]*)")
    public void findByXpath(String xpath) {
        logger.debug("Looking for item with xpath " + xpath);
        this.webDriverContext().setCurrentElement(null);
        WebElement elem = this.webDriverContext().waitForElement(By.xpath((String)xpath));
        Assert.assertNotNull((String)("expecting an element with xpath " + xpath), (Object)elem);
        this.webDriverContext().setCurrentElement(elem);
    }

    @SubSteps.Step(value="FindByName \"?([^\"]*)\"?")
    public WebElement findByName(String name) {
        logger.debug("Looking for item with name " + name);
        this.webDriverContext().setCurrentElement(null);
        WebElement elem = this.webDriverContext().waitForElement(By.name((String)name));
        Assert.assertNotNull((String)("expecting an element with name " + name), (Object)elem);
        this.webDriverContext().setCurrentElement(elem);
        return elem;
    }

    @SubSteps.Step(value="FindFirstTagElementContainingText tag=\"([^\"]*)\" text=\"([^\"]*)\"")
    public void findFirstTagElementContainingText(String tag, String text) {
        logger.debug("Finding tag element " + tag + "and asserting has text " + text);
        this.webDriverContext().setCurrentElement(null);
        WebDriverSubstepsBy.ByTagAndWithText by = WebDriverSubstepsBy.ByTagContainingText(tag, text);
        WebElement elem = MatchingElementResultHandler.AtLeastOneElement.processResults(this.webDriverContext(), by, "expecting at least one child element to contain text: " + text);
        this.webDriverContext().setCurrentElement(elem);
    }

    @SubSteps.Step(value="FindTagElementWithExactText tag=\"([^\"]*)\" text=\"([^\"]*)\"")
    public void findTagElementWithExactText(String tag, String text) {
        logger.debug("Finding tag element " + tag + "and asserting has exact text " + text);
        this.webDriverContext().setCurrentElement(null);
        List elementsWithTagName = this.webDriver().findElements(By.tagName((String)tag));
        WebElement matchingElement = null;
        for (WebElement element : elementsWithTagName) {
            if (!element.getText().equals(text)) continue;
            if (matchingElement == null) {
                matchingElement = element;
                continue;
            }
            Assert.fail((String)("expected one element with tag " + tag + " and text " + text + " but found multiple"));
        }
        Assert.assertNotNull((String)("expecting element with tag " + tag + " and text " + text), (Object)matchingElement);
        this.webDriverContext().setCurrentElement(matchingElement);
    }

    @SubSteps.Step(value="FindChild ByName name=\"?([^\"]*)\"?")
    public WebElement findChildByName(String name) {
        logger.debug("Looking for child with name " + name);
        Assert.assertNotNull((String)"expecting a current element", (Object)this.webDriverContext().getCurrentElement());
        WebElement elem = this.webDriverContext().getCurrentElement().findElement(By.name((String)name));
        Assert.assertNotNull((String)("expecting an element with name " + name), (Object)elem);
        this.webDriverContext().setCurrentElement(elem);
        return elem;
    }

    @SubSteps.Step(value="FindChild ByTagAndAttributes tag=\"?([^\"]*)\"? attributes=\\[(.*)\\]")
    public WebElement findChildByTagAndAttributes(String tag, String attributeString) {
        logger.debug("Looking for child with tag " + tag + " and attributes " + attributeString);
        return this.findChildByTagAndAttributes(tag, attributeString, MatchingElementResultHandler.ExactlyOneElement);
    }

    private WebElement findChildByTagAndAttributes(String tag, String attributeString, MatchingElementResultHandler resultHandler) {
        Assert.assertNotNull((String)"expecting a current element", (Object)this.webDriverContext().getCurrentElement());
        WebElement currentElement = this.webDriverContext().getCurrentElement();
        WebDriverSubstepsBy.ByTagAndAttributes byTagAndAttributes = WebDriverSubstepsBy.ByTagAndAttributes(tag, attributeString);
        WebDriverSubstepsBy.ByCurrentWebElement byCurrentElement = WebDriverSubstepsBy.ByCurrentWebElement(currentElement);
        ByChained chained = new ByChained(new By[]{byCurrentElement, byTagAndAttributes});
        String msg = "failed to locate a child element with tag: " + tag + " and attributes: " + attributeString;
        WebElement elem = resultHandler.processResults(this.webDriverContext(), (By)chained, msg);
        this.webDriverContext().setCurrentElement(elem);
        return elem;
    }

    @SubSteps.Step(value="FindChild ByTagAndAttributes tag=\"?([^\"]*)\"? attributes=\\[(.*)\\] with text=\"([^\"]*)\"")
    public WebElement findChildByTagAndAttributesWithText(String tag, String attributeString, String text) {
        logger.debug("Looking for child with tag " + tag + " and attributes " + attributeString);
        return this.findChildByTagAndAttributes(tag, attributeString, text, MatchingElementResultHandler.ExactlyOneElement);
    }

    private WebElement findChildByTagAndAttributes(String tag, String attributeString, String text, MatchingElementResultHandler resultHandler) {
        Assert.assertNotNull((String)"expecting a current element", (Object)this.webDriverContext().getCurrentElement());
        WebElement currentElement = this.webDriverContext().getCurrentElement();
        WebDriverSubstepsBy.ByTagAndAttributesWithText byTagAndAttributesWithText = WebDriverSubstepsBy.ByTagAndAttributesWithText(tag, attributeString, text);
        WebDriverSubstepsBy.ByCurrentWebElement byCurrentElement = WebDriverSubstepsBy.ByCurrentWebElement(currentElement);
        ByChained chained = new ByChained(new By[]{byCurrentElement, byTagAndAttributesWithText});
        String msg = "failed to locate a child element with tag: " + tag + ", attributes: " + attributeString + " and text: " + text;
        WebElement elem = resultHandler.processResults(this.webDriverContext(), (By)chained, msg);
        this.webDriverContext().setCurrentElement(elem);
        return elem;
    }

    @SubSteps.Step(value="FindFirstChild ByTagAndAttributes tag=\"?([^\"]*)\"? attributes=\\[(.*)\\]")
    public WebElement findFirstChildByTagAndAttributes(String tag, String attributeString) {
        logger.debug("Looking for first child with tag " + tag + " and attributes " + attributeString);
        return this.findChildByTagAndAttributes(tag, attributeString, MatchingElementResultHandler.AtLeastOneElement);
    }

    @SubSteps.Step(value="FindCheckbox inside tag=\"?([^\"]*)\"? with label=\"([^\"]*)\"")
    public WebElement findCheckBox(String tag, String label) {
        return this.findInputInsideTag(label, tag, "checkbox");
    }

    @SubSteps.Step(value="FindRadioButton inside tag=\"?([^\"]*)\"? with label=\"([^\"]*)\"")
    public WebElement findRadioButton(String tag, String label) {
        return this.findInputInsideTag(label, tag, "radio");
    }

    public WebElement findInputInsideTag(String label, String tag, String inputType) {
        WebElement elem = null;
        this.webDriverContext().setCurrentElement(null);
        List tagElems = this.webDriver().findElements(By.tagName((String)tag));
        this.checkElements("expecting some elements of tag: " + tag, tagElems);
        ArrayList<WebElement> matchingElems = null;
        for (WebElement tagElem : tagElems) {
            List inputElements;
            if (label.compareTo(tagElem.getText()) != 0 || (inputElements = tagElem.findElements(By.tagName((String)"input"))) == null || inputElements.isEmpty()) continue;
            for (WebElement inputElement : inputElements) {
                String type = inputElement.getAttribute("type");
                if (type == null || type.compareToIgnoreCase(inputType) != 0) continue;
                if (matchingElems == null) {
                    matchingElems = new ArrayList<WebElement>();
                }
                matchingElems.add(inputElement);
            }
        }
        elem = MatchingElementResultHandler.checkForOneMatchingElement("expecting an input of type " + inputType + " inside tag [" + tag + "] with label [" + label + "]", matchingElems);
        this.webDriverContext().setCurrentElement(elem);
        return elem;
    }

    public void checkElements(String msg, List<WebElement> tagElems) {
        Assert.assertNotNull((String)msg, tagElems);
        Assert.assertTrue((String)msg, (!tagElems.isEmpty() ? 1 : 0) != 0);
    }

    @SubSteps.Step(value="FindByTagAndAttributes tag=\"?([^\"]*)\"? attributes=\\[(.*)\\]")
    public WebElement findByTagAndAttributes(String tag, String attributeString) {
        logger.debug("Looking for item with tag " + tag + " and attributes " + attributeString);
        return this.findByTagAndAttributes(tag, attributeString, MatchingElementResultHandler.ExactlyOneElement);
    }

    private WebElement findByTagAndAttributes(String tag, String attributeString, MatchingElementResultHandler handler) {
        this.webDriverContext().setCurrentElement(null);
        WebElement rtn = null;
        WebDriverSubstepsBy.ByTagAndAttributes by = WebDriverSubstepsBy.ByTagAndAttributes(tag, attributeString);
        String msg = "failed to locate an element with tag: " + tag + " and attributes: " + attributeString;
        rtn = handler.processResults(this.webDriverContext(), by, msg);
        this.webDriverContext().setCurrentElement(rtn);
        return rtn;
    }

    @SubSteps.Step(value="FindFirstByTagAndAttributes tag=\"?([^\"]*)\"? attributes=\\[(.*)\\]")
    public WebElement findFirstByTagAndAttributes(String tag, String attributeString) {
        logger.debug("Looking for first item with tag " + tag + " and attributes " + attributeString);
        return this.findByTagAndAttributes(tag, attributeString, MatchingElementResultHandler.AtLeastOneElement);
    }

    @SubSteps.Step(value="FindNthByTagAndAttributes n=\"?([^\"]*)\"? tag=\"?([^\"]*)\"? attributes=\\[(.*)\\]")
    public WebElement findNthByTagAndAttributes(@SubSteps.StepParameter(converter=IntegerConverter.class) Integer nth, String tag, String attributeString) {
        logger.debug("Looking for nth item with tag " + tag + " and attributes " + attributeString);
        this.webDriverContext().setCurrentElement(null);
        WebElement rtn = null;
        WebDriverSubstepsBy.ByTagAndAttributes by = WebDriverSubstepsBy.NthByTagAndAttributes(tag, attributeString, nth);
        String msg = "failed to locate the " + nth + "th element with tag: " + tag + " and attributes: " + attributeString;
        MatchingElementResultHandler.NthElement handler = new MatchingElementResultHandler.NthElement(nth);
        rtn = handler.processResults(this.webDriverContext(), by, msg);
        this.webDriverContext().setCurrentElement(rtn);
        return rtn;
    }

    @SubSteps.Step(value="FindParentByTagAndAttributes tag=\"?([^\"]*)\"? attributes=\\[(.*)\\] ThatHasChild tag=\"?([^\"]*)\"? text=\"([^\"]*)\"")
    public WebElement findParentByTagAndAttributesThatHasChildWithTagAndText(String tag, String attributeString, String childTag, String childText) {
        this.webDriverContext().setCurrentElement(null);
        WebElement rtn = null;
        WebDriverSubstepsBy.ByTagAndAttributes by = WebDriverSubstepsBy.ByTagAndAttributes(tag, attributeString);
        WebDriverSubstepsBy.ByTagAndWithText childBy = WebDriverSubstepsBy.ByTagAndWithText(childTag, childText);
        String assertionMessage = "Failed to locate a parent element with tag: " + tag + " and attributes: " + attributeString + " with a child element of tag: " + childTag + " with text: " + childText;
        String findParentAssertionMessage = "failed to locate an element with tag: " + tag + " and attributes: " + attributeString;
        String multipleChildrenMessage = "More than one child element found for parent with tag: " + childTag + " and text: " + childText;
        rtn = this.findParentByWithChildBy(by, childBy, assertionMessage, findParentAssertionMessage, multipleChildrenMessage);
        return rtn;
    }

    private WebElement findParentByWithChildBy(By by, By childBy, String assertionMessage, String findParentAssertionMessage, String multipleChildrenMessage) {
        boolean repeat = true;
        WebElement rtn = null;
        while (repeat) {
            repeat = false;
            try {
                rtn = this.findParentWithChildByInternal(by, childBy, assertionMessage, findParentAssertionMessage, multipleChildrenMessage);
            }
            catch (StaleElementReferenceException e) {
                logger.debug("stale element exception caught, retrying..");
                repeat = true;
            }
        }
        Assert.assertNotNull((String)assertionMessage, rtn);
        this.webDriverContext().setCurrentElement(rtn);
        return rtn;
    }

    private WebElement findParentWithChildByInternal(By by, By childBy, String assertionMessage, String findParentAssertionMessage, String multipleChildrenMessage) {
        ArrayList<WebElement> matchingElements = null;
        List candidateParentElements = this.webDriver().findElements(by);
        Assert.assertNotNull((String)findParentAssertionMessage, (Object)candidateParentElements);
        Assert.assertFalse((String)findParentAssertionMessage, (boolean)candidateParentElements.isEmpty());
        for (WebElement parent : candidateParentElements) {
            List children = parent.findElements(childBy);
            if (children == null || children.isEmpty()) continue;
            if (matchingElements == null) {
                matchingElements = new ArrayList<WebElement>();
            }
            matchingElements.add(parent);
            if (children.size() <= 1) continue;
            logger.info(multipleChildrenMessage);
        }
        WebElement rtn = MatchingElementResultHandler.checkForOneMatchingElement(assertionMessage, matchingElements);
        return rtn;
    }

    @SubSteps.Step(value="FindParentByTagAndAttributes tag=\"?([^\"]*)\"? attributes=\\[(.*)\\] ThatHasChild tag=\"?([^\"]*)\"? attributes=\\[(.*)\\]")
    public WebElement findParentByTagAndAttributesThatHasChildWithTagAndAttributes(String tag, String attributeString, String childTag, String childAttributeString) {
        this.webDriverContext().setCurrentElement(null);
        WebElement rtn = null;
        WebDriverSubstepsBy.ByTagAndAttributes by = WebDriverSubstepsBy.ByTagAndAttributes(tag, attributeString);
        WebDriverSubstepsBy.ByTagAndAttributes childBy = WebDriverSubstepsBy.ByTagAndAttributes(childTag, childAttributeString);
        String assertionMessage = "Failed to locate a parent element with tag: " + tag + " and attributes: " + attributeString + " with a child element of tag: " + childTag + " and attributes: " + childAttributeString;
        String findParentAssertionMessage = "failed to locate an element with tag: " + tag + " and attributes: " + attributeString;
        String multipleChildrenMessage = "More than one child element found for parent with tag: " + childTag + " and and attributes: " + childAttributeString;
        rtn = this.findParentByWithChildBy(by, childBy, assertionMessage, findParentAssertionMessage, multipleChildrenMessage);
        return rtn;
    }

    public WebElement findElementWithText(String type, String text) {
        WebElement elem = null;
        List elems = this.webDriver().findElements(By.tagName((String)type));
        if (elems != null) {
            for (WebElement e : elems) {
                if (!text.equalsIgnoreCase(e.getText())) continue;
                elem = e;
                break;
            }
        }
        return elem;
    }

    @SubSteps.Step(value="FindById ([^\"]*) and text = \"([^\"]*)\"")
    public void findByIdAndText(String id, String expected) {
        logger.debug("Finding element with id " + id + " and text " + expected);
        try {
            this.webDriverContext().setCurrentElement(null);
            WebDriverSubstepsBy.ByIdAndText byIdAndText = WebDriverSubstepsBy.ByIdAndText(id, expected);
            WebElement elem = this.webDriverContext().waitForElement(byIdAndText);
            Assert.assertNotNull((String)("expecting to find an element with id: " + id), (Object)elem);
            this.webDriverContext().setCurrentElement(elem);
        }
        catch (TimeoutException e) {
            logger.debug("timed out waiting for id: " + id + " with text: " + expected + " page src:\n" + this.webDriver().getPageSource());
            throw e;
        }
    }

    @SubSteps.Step(value="FindFirstChildElementContainingText xpath=\"([^\"]*)\" text=\"([^\"]*)\"")
    public void findChildElementContainingText(String xpath, String text) {
        logger.debug("Find child element with xpath " + xpath + " has the text " + text);
        WebDriverSubstepsBy.ByCurrentWebElement byCurrentElement = WebDriverSubstepsBy.ByCurrentWebElement(this.webDriverContext().getCurrentElement());
        ByChained chained = new ByChained(new By[]{byCurrentElement, WebDriverSubstepsBy.ByXpathContainingText(xpath, text)});
        this.webDriverContext().setCurrentElement(null);
        WebElement elem = MatchingElementResultHandler.AtLeastOneElement.processResults(this.webDriverContext(), (By)chained, "expecting at least one child element to contain text: " + text);
        this.webDriverContext().setCurrentElement(elem);
    }

    @SubSteps.Step(value="FindFirstTagElementStartingWithText tag=\"([^\"]*)\" text=\"([^\"]*)\"")
    public void findFirstTagElementStartingWithText(String tag, String text) {
        logger.debug("findTagElementStartsWithText tag: " + tag + " has text " + text);
        this.webDriverContext().setCurrentElement(null);
        WebDriverSubstepsBy.ByTagAndWithText by = WebDriverSubstepsBy.ByTagStartingWithText(tag, text);
        WebElement elem = MatchingElementResultHandler.AtLeastOneElement.processResults(this.webDriverContext(), by, "expecting at least one child element to contain text: " + text);
        this.webDriverContext().setCurrentElement(elem);
    }

    @SubSteps.Step(value="FindByTagAndAttributesWithText tag=\"?([^\"]*)\"? attributes=\\[(.*)\\] with text=\"([^\"]*)\"")
    public WebElement findByTagAndAttributesWithText(String tag, String attributeString, String text) {
        return this.findByTagAndAttributesWithText(tag, attributeString, text, MatchingElementResultHandler.ExactlyOneElement);
    }

    private WebElement findByTagAndAttributesWithText(String tag, String attributeString, String text, MatchingElementResultHandler handler) {
        this.webDriverContext().setCurrentElement(null);
        WebElement rtn = null;
        WebDriverSubstepsBy.ByTagAndAttributesWithText by = WebDriverSubstepsBy.ByTagAndAttributesWithText(tag, attributeString, text);
        String msg = "failed to locate an element with tag: " + tag + ", attributes: " + attributeString + ", and text: " + text;
        rtn = handler.processResults(this.webDriverContext(), by, msg);
        this.webDriverContext().setCurrentElement(rtn);
        return rtn;
    }
}

