/*
 * Decompiled with CFR 0.152.
 */
package com.technophobia.webdriver.substeps.impl;

import com.google.common.base.Function;
import com.technophobia.substeps.model.Scope;
import com.technophobia.substeps.model.SubSteps;
import com.technophobia.substeps.runner.ExecutionContext;
import com.technophobia.substeps.step.StepImplementationUtils;
import com.technophobia.webdriver.substeps.impl.AbstractWebDriverSubStepImplementations;
import com.technophobia.webdriver.substeps.impl.FinderWebDriverSubStepImplementations;
import com.technophobia.webdriver.substeps.runner.DefaultExecutionSetupTearDown;
import com.technophobia.webdriver.util.WebDriverSubstepsBy;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SubSteps.StepImplementations(requiredInitialisationClasses={DefaultExecutionSetupTearDown.class})
public class AssertionWebDriverSubStepImplementations
extends AbstractWebDriverSubStepImplementations {
    private static final Logger logger = LoggerFactory.getLogger(AssertionWebDriverSubStepImplementations.class);
    private final FinderWebDriverSubStepImplementations finder = new FinderWebDriverSubStepImplementations();

    @SubSteps.Step(value="AssertCurrentElement text=\"([^\"]*)\"")
    public void assertTextInCurrentElement(String expected) {
        logger.debug("Asserting the current element has the text " + expected);
        Assert.assertThat((Object)this.webDriverContext().getCurrentElement().getText(), (Matcher)CoreMatchers.is((Object)expected));
    }

    @SubSteps.Step(value="AssertCurrentInput value=\"([^\"]*)\"")
    public void assertValueInCurrentInput(String expected) {
        logger.debug("Asserting the current input has the value" + expected);
        Assert.assertThat((Object)this.webDriverContext().getCurrentElement().getAttribute("value"), (Matcher)CoreMatchers.is((Object)expected));
    }

    @SubSteps.Step(value="AssertCurrentElement text contains \"([^\"]*)\"")
    public void assertTextInCurrentElementContains(String expected) {
        logger.debug("Asserting current element contains the text " + expected);
        Assert.assertThat((Object)this.webDriverContext().getCurrentElement().getText(), (Matcher)Matchers.containsString((String)expected));
    }

    @SubSteps.Step(value="AssertCurrentElement attribute=\"([^\"]*)\" value=\"([^\"]*)\"")
    public void assertAttributeInCurrentElement(String attribute, String expected) {
        logger.debug("Asserting current element has the attribute " + attribute + "with value " + expected);
        String attributeValue = this.webDriverContext().getCurrentElement().getAttribute(attribute);
        Assert.assertNotNull((String)("Expecting to find attribute " + attribute + " on current element"), (Object)attributeValue);
        Assert.assertThat((Object)attributeValue, (Matcher)CoreMatchers.is((Object)expected));
    }

    @SubSteps.Step(value="AssertTagElementContainsAttribute tag=\"([^\"]*)\" attributeName=\"([^\"]*)\" attributeValue=\"([^\"]*)\"")
    public void assertTagElementContainsAttribute(String tag, String attributeName, String attributeValue) {
        logger.debug("Asserting tag element " + tag + " has attribute " + attributeName + " with value " + attributeValue);
        List itemList = this.webDriver().findElements(By.tagName((String)tag));
        boolean found = false;
        for (WebElement item : itemList) {
            String itemAttributeValue = item.getAttribute(attributeName);
            if (!StringUtils.isNotBlank((String)itemAttributeValue) || !itemAttributeValue.contains(attributeValue)) continue;
            found = true;
            break;
        }
        Assert.assertTrue((String)("expecting child element to contain attribute: " + attributeName + " with value " + attributeValue), (boolean)found);
    }

    @SubSteps.Step(value="AssertPageTitle is \"([^\"]*)\"")
    public void assertPageTitle(String expectedTitle) {
        logger.debug("Asserting the page title is " + expectedTitle);
        Assert.assertEquals((String)"unexpected page title", (Object)expectedTitle, (Object)this.webDriver().getTitle());
    }

    @SubSteps.Step(value="AssertPageSourceContains \"(.*)\"$")
    public void pageSourceContains(String expected) {
        logger.debug("Checking page source for expeted content [" + expected + "]");
        String pageSource = this.webDriver().getPageSource();
        Assert.assertThat((Object)pageSource, (Matcher)Matchers.containsString((String)expected));
    }

    @SubSteps.Step(value="AssertCheckBox checked=\"?([^\"]*)\"?")
    public void assertCheckBoxIsChecked(String checkedString) {
        WebElement currentElem = this.webDriverContext().getCurrentElement();
        AssertionWebDriverSubStepImplementations.assertElementIs(currentElem, "input", "checkbox");
        boolean checked = Boolean.parseBoolean(checkedString.trim());
        if (checked) {
            Assert.assertTrue((String)"expecting checkbox to be checked", (boolean)currentElem.isSelected());
        } else {
            Assert.assertFalse((String)"expecting checkbox not to be checked", (boolean)currentElem.isSelected());
        }
    }

    @SubSteps.Step(value="AssertRadioButton checked=\"?([^\"]*)\"?")
    public void assertRadioButtonIsChecked(String checkedString) {
        WebElement currentElem = this.webDriverContext().getCurrentElement();
        AssertionWebDriverSubStepImplementations.assertElementIs(currentElem, "input", "radio");
        boolean checked = Boolean.parseBoolean(checkedString.trim());
        if (checked) {
            Assert.assertTrue((String)"expecting radio button to be checked", (boolean)currentElem.isSelected());
        } else {
            Assert.assertFalse((String)"expecting radio button not to be checked", (boolean)currentElem.isSelected());
        }
    }

    @SubSteps.Step(value="AssertCurrentElement has attributes=\\[(.*)\\]")
    public void assertCurrentElementHasAttributes(String attributeString) {
        WebElement currentElem = this.webDriverContext().getCurrentElement();
        Map expectedAttributes = StepImplementationUtils.convertToMap((String)attributeString);
        Assert.assertTrue((String)("element doesn't have expected attributes: " + attributeString), (boolean)this.elementHasExpectedAttributes(currentElem, expectedAttributes));
    }

    public static void assertElementIs(WebElement elem, String tag, String type) {
        Assert.assertNotNull((String)"expecting an element", (Object)elem);
        Assert.assertTrue((String)"unexpected tag", (elem.getTagName() != null && elem.getTagName().compareToIgnoreCase(tag) == 0 ? 1 : 0) != 0);
        if (type != null) {
            Assert.assertTrue((String)"unexpected type", (elem.getAttribute("type") != null && elem.getAttribute("type").compareToIgnoreCase(type) == 0 ? 1 : 0) != 0);
        }
    }

    public static void assertElementIs(WebElement elem, String tag) {
        AssertionWebDriverSubStepImplementations.assertElementIs(elem, tag, null);
    }

    @SubSteps.Step(value="RememberForScenario textFrom \"([^\"]*)\" as \"([^\"]*)\"")
    public void rememberForScenario(String elementId, String nameToSaveAs) {
        WebElement element = this.finder.findById(elementId);
        String text = element.getText();
        ExecutionContext.put((Scope)Scope.SCENARIO, (String)nameToSaveAs, (Object)text);
    }

    @SubSteps.Step(value="AssertDifferent rememberedValue \"([^\"]*)\" compareToElement \"([^\"]*)\"")
    public void assertDifferent(String rememberedValueName, String elementId) {
        WebElement element = this.finder.findById(elementId);
        String text = element.getText();
        Object retrievedValue = null;
        for (Scope scope : Scope.values()) {
            Object valueFromScope = ExecutionContext.get((Scope)scope, (String)rememberedValueName);
            if (valueFromScope == null) continue;
            retrievedValue = valueFromScope;
        }
        Assert.assertFalse((String)"The remembered value was different to the text of the element compared against", (boolean)retrievedValue.equals(text));
    }

    @SubSteps.Step(value="AssertSame rememberedValue \"([^\"]*)\" compareToElement \"([^\"]*)\"")
    public void assertSame(String rememberedValueName, String elementId) {
        WebElement element = this.finder.findById(elementId);
        String text = element.getText();
        Object retrievedValue = null;
        for (Scope scope : Scope.values()) {
            Object valueFromScope = ExecutionContext.get((Scope)scope, (String)rememberedValueName);
            if (valueFromScope == null) continue;
            retrievedValue = valueFromScope;
        }
        Assert.assertEquals((String)"The remembered value was different to the text of the element compared against", (Object)retrievedValue.toString(), (Object)text);
    }

    @SubSteps.Step(value="AssertEventuallyNotEmpty id=\"([^\"]*)\"")
    public void assertEventuallyNotEmpty(String elementId) {
        WebElement webElement = this.waitForElementToContainSomeText(By.id((String)elementId));
        Assert.assertNotNull((String)String.format("Expected to find a non-empty element with 'id=%s' but didn't.", elementId), (Object)webElement);
    }

    @SubSteps.Step(value="AssertEventuallyContains ([^\"]*) \"([^\"]*)\"")
    public void assertEventuallyContains(String elementId, String text) {
        WebElement webElement = this.webDriverContext().waitForElement(WebDriverSubstepsBy.ByIdContainingText(elementId, text));
        Assert.assertNotNull((String)String.format("Expected to find a element with 'id=%s' containing text '%s' but didn't.", elementId, text), (Object)webElement);
    }

    @SubSteps.Step(value="AssertNotPresent text=\"([^\"]*)\"")
    public void assertNotPresent(String text) {
        String pageSource = this.webDriver().getPageSource();
        Assert.assertThat((Object)pageSource, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)text)));
    }

    public WebElement waitForElementToContainSomeText(final By by) {
        WebDriverWait wait = new WebDriverWait(this.webDriver(), 10L);
        Function<WebDriver, WebElement> condition2 = new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                WebElement rtn = driver.findElement(by);
                String potentialVal = rtn.getText();
                if (potentialVal != null) {
                    return rtn;
                }
                return null;
            }
        };
        return (WebElement)wait.until((Function)condition2);
    }
}

