/*
 * Decompiled with CFR 0.152.
 */
package com.technophobia.webdriver.substeps.impl;

import com.technophobia.substeps.model.SubSteps;
import com.technophobia.webdriver.substeps.impl.AbstractWebDriverSubStepImplementations;
import com.technophobia.webdriver.substeps.impl.FinderWebDriverSubStepImplementations;
import com.technophobia.webdriver.substeps.runner.Condition;
import com.technophobia.webdriver.substeps.runner.DefaultExecutionSetupTearDown;
import com.technophobia.webdriver.substeps.runner.WebdriverSubstepsPropertiesConfiguration;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SubSteps.StepImplementations(requiredInitialisationClasses={DefaultExecutionSetupTearDown.class})
public class ActionWebDriverSubStepImplementations
extends AbstractWebDriverSubStepImplementations {
    private static final Logger logger = LoggerFactory.getLogger(ActionWebDriverSubStepImplementations.class);
    private final FinderWebDriverSubStepImplementations locator = new FinderWebDriverSubStepImplementations();

    @SubSteps.Step(value="NavigateTo ([^\"]*)")
    public void navigateTo(String url) {
        logger.debug("About to navigate to " + url);
        if (url.startsWith("file") || url.startsWith("http")) {
            this.webDriver().get(url);
        } else {
            this.webDriver().get(this.normaliseURL(url));
        }
    }

    @SubSteps.Step(value="ClickById ([^\"]*)")
    public void clickById(String id) {
        logger.debug("About to click item with id " + id);
        this.locator.findById(id);
        this.click();
    }

    @SubSteps.Step(value="Click")
    public void click() {
        logger.debug("About to click on current element");
        WebElement element = this.webDriverContext().getCurrentElement();
        this.clickElementWhenAvailable(element);
    }

    private void clickElementWhenAvailable(WebElement elem) {
        long timeout = System.currentTimeMillis() + 1000L * WebdriverSubstepsPropertiesConfiguration.INSTANCE.defaultTimeout();
        boolean success = false;
        while (!success && System.currentTimeMillis() < timeout) {
            try {
                elem.click();
                success = true;
            }
            catch (WebDriverException e) {
                if (!e.getMessage().contains("Element is not clickable") && !e.getMessage().contains("Element is not currently visible")) {
                    throw e;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    logger.debug("not clickable this time");
                }
            }
        }
        Assert.assertTrue((String)"Failed to click on element within timeout", (boolean)success);
    }

    @SubSteps.Step(value="ClickLink \"([^\"]*)\"")
    public void clickLink(String linkText) {
        logger.debug("About to click link with text " + linkText);
        this.webDriverContext().setCurrentElement(null);
        WebElement elem = this.webDriver().findElement(By.linkText((String)linkText));
        Assert.assertNotNull((String)("expecting to find a link: " + linkText), (Object)elem);
        this.webDriverContext().setCurrentElement(elem);
        elem.click();
    }

    @SubSteps.Step(value="ClickButton ([^\"]*)")
    public void clickButton(String buttonText) {
        logger.debug("About to click button with text " + buttonText);
        this.webDriverContext().setCurrentElement(null);
        WebElement elem = this.locator.findElementWithText("button", buttonText.trim());
        Assert.assertNotNull((String)("expecting to find a button: " + buttonText), (Object)elem);
        this.webDriverContext().setCurrentElement(elem);
        elem.click();
    }

    @SubSteps.Step(value="ClickSubmitButton \"([^\"]*)\"")
    public void clickInput(String buttonText) {
        logger.debug("About to click submit button with text " + buttonText);
        this.webDriverContext().setCurrentElement(null);
        List elems = this.webDriver().findElements(By.tagName((String)"input"));
        ArrayList<WebElement> matchingElems = null;
        for (WebElement e : elems) {
            if (!e.getAttribute("value").equals(buttonText)) continue;
            if (matchingElems == null) {
                matchingElems = new ArrayList<WebElement>();
            }
            matchingElems.add(e);
        }
        if (matchingElems != null && matchingElems.size() > 1) {
            Assert.fail((String)"Found too many elements that meet this criteria");
        } else if (matchingElems != null) {
            this.webDriverContext().setCurrentElement((WebElement)matchingElems.get(0));
        }
        this.webDriverContext().getCurrentElement().click();
    }

    @SubSteps.Step(value="WaitFor ([^\"]*)")
    public void waitFor(String value) {
        logger.debug("About to wait for " + value + "ms");
        long ms = Long.parseLong(value);
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            logger.debug("interupt ex");
        }
    }

    @SubSteps.Step(value="WaitForPageTitle \"([^\"]*)\"")
    public void waitForPageTitle(final String expectedTitle) {
        logger.debug("Waiting for " + expectedTitle + " page");
        boolean conditionMet = this.webDriverContext().waitForCondition(new Condition(){

            @Override
            public boolean conditionMet() {
                String pageTitle = ActionWebDriverSubStepImplementations.this.webDriver().getTitle();
                logger.debug(String.format("wait for page. Expected='%s', actual='%s'", expectedTitle, pageTitle));
                return pageTitle.equals(expectedTitle);
            }
        });
        if (!conditionMet) {
            logger.debug(expectedTitle + " page not found");
        }
        Assert.assertTrue((boolean)conditionMet);
    }

    private String normaliseURL(String relativeURL) {
        return this.normalise(WebdriverSubstepsPropertiesConfiguration.INSTANCE.baseURL() + relativeURL);
    }

    private String normalise(String urlToNormalise) {
        try {
            return new URI(urlToNormalise).toString();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("The url " + urlToNormalise + " is invalid.", ex);
        }
    }

    @SubSteps.Step(value="SwitchFrameToCurrentElement")
    public void switchFrameToCurrentElement() {
        WebDriver.TargetLocator targetLocator = this.webDriver().switchTo();
        WebDriver refocusedWebDriver = targetLocator.frame(this.webDriverContext().getCurrentElement());
        Assert.assertTrue((String)"Webdriver target locator has returned a different webdriver instance, some webdriver-substeps changes will be required to support this", (refocusedWebDriver == this.webDriver() ? 1 : 0) != 0);
    }

    @SubSteps.Step(value="PerformDoubleClick")
    public void doDoubleClick() {
        Actions actions = new Actions(this.webDriver());
        actions.doubleClick(this.webDriverContext().getCurrentElement());
        actions.perform();
    }

    @SubSteps.Step(value="PerformContextClick")
    public void performContextClick() {
        Actions actions = new Actions(this.webDriver());
        actions.contextClick(this.webDriverContext().getCurrentElement());
        actions.perform();
    }

    @SubSteps.Step(value="DismissAlert with message \"([^\"]*)\"")
    public void dismissAlertWithMessage(String message) {
        Alert alert = this.webDriverContext().getWebDriver().switchTo().alert();
        Assert.assertThat((Object)alert.getText(), (Matcher)CoreMatchers.is((Object)message));
        alert.accept();
    }
}

