/*
 * Decompiled with CFR 0.152.
 */
package com.technophobia.webdriver.substeps.impl;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.technophobia.substeps.model.Scope;
import com.technophobia.substeps.runner.ExecutionContextSupplier;
import com.technophobia.substeps.runner.MutableSupplier;
import com.technophobia.substeps.runner.ProvidesScreenshot;
import com.technophobia.webdriver.util.WebDriverContext;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public abstract class AbstractWebDriverSubStepImplementations
implements ProvidesScreenshot {
    private final MutableSupplier<WebDriverContext> webDriverContextSupplier = new ExecutionContextSupplier(Scope.SUITE, "_webdriver_context_key");

    protected boolean elementHasExpectedAttributes(WebElement e, Map<String, String> expectedAttributes) {
        HashMap<String, String> actualValues = new HashMap<String, String>();
        for (String key : expectedAttributes.keySet()) {
            String elementVal = e.getAttribute(key);
            actualValues.put(key, elementVal);
        }
        MapDifference difference = Maps.difference(expectedAttributes, actualValues);
        return difference.areEqual();
    }

    protected WebDriver webDriver() {
        return ((WebDriverContext)this.webDriverContextSupplier.get()).getWebDriver();
    }

    protected WebDriverContext webDriverContext() {
        return (WebDriverContext)this.webDriverContextSupplier.get();
    }

    public byte[] getScreenshotBytes() {
        WebDriver webDriver = this.webDriver();
        return TakesScreenshot.class.isAssignableFrom(webDriver.getClass()) ? this.getScreenshotBytes((TakesScreenshot)webDriver) : null;
    }

    private byte[] getScreenshotBytes(TakesScreenshot screenshotTaker) {
        return (byte[])screenshotTaker.getScreenshotAs(OutputType.BYTES);
    }
}

