/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.majortom.event.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Objects;
import javax.annotation.Nullable;
import org.starchartlabs.alloy.core.MoreObjects;
import org.starchartlabs.majortom.event.model.NotificationLevel;

public class Notification {
    public static final String SUBJECT = Notification.class.getName() + ":1";
    private static final Gson GSON = new GsonBuilder().create();
    private final String message;
    @Nullable
    private final NotificationLevel level;

    public Notification(String message, @Nullable NotificationLevel level) {
        this.message = Objects.requireNonNull(message);
        this.level = level;
    }

    public String getMessage() {
        return this.message;
    }

    @Nullable
    public NotificationLevel getLevel() {
        return this.level;
    }

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getMessage(), this.getLevel()});
    }

    public boolean equals(@Nullable Object obj) {
        boolean result = false;
        if (obj instanceof Notification) {
            Notification compare = (Notification)obj;
            result = Objects.equals(compare.getMessage(), this.getMessage()) && Objects.equals((Object)compare.getLevel(), (Object)this.getLevel());
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("message", (Object)this.getMessage()).add("level", (Object)this.getLevel()).toString();
    }

    public static Notification fromJson(String json) {
        Objects.requireNonNull(json);
        return (Notification)GSON.fromJson(json, Notification.class);
    }
}

