/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver.browser;

import com.google.common.base.Strings;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Test;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.stjs.generator.BridgeClass;
import org.stjs.generator.ClassWithJavascript;
import org.stjs.testing.driver.AsyncProcess;
import org.stjs.testing.driver.DriverConfiguration;
import org.stjs.testing.driver.HttpLongPollingServer;
import org.stjs.testing.driver.JUnitSession;
import org.stjs.testing.driver.MultiTestMethod;
import org.stjs.testing.driver.TestClassAttributes;
import org.stjs.testing.driver.TestClassAttributesRepository;
import org.stjs.testing.driver.TestResult;
import org.stjs.testing.driver.browser.AbstractBrowser;

public abstract class LongPollingBrowser
extends AbstractBrowser {
    private final Exchanger<MultiTestMethod> exchanger = new Exchanger();
    private final TestClassAttributesRepository testClasses;
    private volatile MultiTestMethod methodUnderExecution = null;
    private long id;
    private volatile boolean isDead = false;

    public LongPollingBrowser(DriverConfiguration config) {
        super(config);
        this.testClasses = new TestClassAttributesRepository(config.getStjsClassResolver(), config.getDependencyCollector());
    }

    protected String getStartPageUri(long browserId, boolean persistent) {
        return "start.html?browserId=" + browserId + "&persistent=" + persistent;
    }

    protected String getStartPageUrl(long browserId, boolean persistent) {
        return this.getConfig().getServerURL() + this.getStartPageUri(browserId, persistent);
    }

    protected void registerWithLongPollingServer() {
        this.id = JUnitSession.getInstance().getDependency(HttpLongPollingServer.class).registerBrowserSession(this);
        if (this.getConfig().isDebugEnabled()) {
            System.out.println("Browser " + this.id + " is " + this.getClass().getSimpleName());
        }
    }

    @Override
    public void start() throws InitializationError {
        try {
            this.doStart();
        }
        catch (InitializationError ie) {
            this.markAsDead();
            throw ie;
        }
        catch (Throwable t) {
            this.markAsDead();
            throw new InitializationError(t);
        }
    }

    protected abstract void doStart() throws InitializationError;

    public MultiTestMethod awaitNextTest() {
        try {
            if (this.getConfig().isDebugEnabled()) {
                System.out.println("Browser " + this.id + " is waiting for a new test");
            }
            this.methodUnderExecution = this.exchanger.exchange(null);
            if (this.getConfig().isDebugEnabled()) {
                if (this.methodUnderExecution != null) {
                    System.out.println("Browser " + this.id + " has picked up the test " + this.methodUnderExecution.getMethod().getMethod());
                } else {
                    System.out.println("Browser " + this.id + " has no more tests");
                }
            }
            return this.methodUnderExecution;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void executeTest(MultiTestMethod method) {
        if (this.isDead) {
            this.reportAsDead(method);
            return;
        }
        try {
            if (this.getConfig().isDebugEnabled()) {
                System.out.println("Test " + method.getMethod().getMethod() + " is available for browser " + this.id);
            }
            this.exchanger.exchange(method, this.getConfig().getTestTimeout(), TimeUnit.SECONDS);
            if (this.getConfig().isDebugEnabled()) {
                System.out.println("Browser " + this.id + " has picked up the new test");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            this.markAsDead();
            this.reportAsDead(method);
        }
    }

    private void reportAsDead(MultiTestMethod method) {
        method.notifyExecutionResult(TestResult.deadBrowser(this.getClass().getSimpleName(), this.getConfig().getTestTimeout() + " seconds passed and the browser didn't contact back the ST-JS JUnit runner"));
    }

    @Override
    public void notifyNoMoreTests() {
        if (this.isDead) {
            return;
        }
        try {
            if (this.getConfig().isDebugEnabled()) {
                System.out.println("Browser " + this.id + " has been notified that no more tests are coming");
            }
            this.exchanger.exchange(null, this.getConfig().getTestTimeout(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            this.markAsDead();
        }
    }

    public MultiTestMethod getMethodUnderExecution() {
        return this.methodUnderExecution;
    }

    public void sendTestFixture(MultiTestMethod meth, HttpExchange exchange) throws Exception {
        TestClassAttributes attr = this.testClasses.getAttributes(meth.getTestClass());
        Test test = (Test)meth.getMethod().getAnnotation(Test.class);
        StringBuilder resp = new StringBuilder(8192);
        resp.append("<html>\n");
        resp.append("<head>\n");
        this.appendScriptTag(resp, this.httpPath(new URI("webjar:/stjs.js")));
        this.appendScriptTag(resp, "/junit.js");
        resp.append("<script language='javascript'>stjs.mainCallDisabled=true;</script>\n");
        for (String script : attr.getScripts()) {
            this.appendScriptTag(resp, script);
        }
        for (String script : attr.getScriptsBefore()) {
            this.appendScriptTag(resp, script);
        }
        LinkedHashSet<URI> jsUris = new LinkedHashSet<URI>();
        for (ClassWithJavascript dep : attr.getDependencies()) {
            if (!attr.getScripts().isEmpty() && dep instanceof BridgeClass) {
                System.out.println("WARNING: You're using @Scripts deprecated annotation that disables the automatic inclusion of the Javascript files of the bridges you're using! Please consider using @ScriptsBefore and/or @ScriptsAfter instead.");
                continue;
            }
            for (URI file : dep.getJavascriptFiles()) {
                jsUris.add(file);
            }
        }
        for (URI uri : jsUris) {
            this.appendScriptTag(resp, this.httpPath(uri));
        }
        for (String script : attr.getScriptsAfter()) {
            this.appendScriptTag(resp, script);
        }
        resp.append("<script language='javascript'>\n");
        if (this.getConfig().isDebugJavaScript()) {
            resp.append(" function runTest() {\n");
            resp.append("    (elem=document.getElementById('startSection')).parentNode.removeChild(elem);\n");
        } else {
            resp.append("  window.onload=function(){\n");
        }
        resp.append("    Assert=window;\n");
        resp.append("    try{\n");
        String testedClassName = attr.getStjsClass().getJavascriptClassName();
        resp.append("        parent.startingTest('" + testedClassName + "', '" + meth.getName() + "');\n");
        resp.append("        var stjsTest = new " + testedClassName + "();\n");
        resp.append("        var stjsResult = 'OK';\n");
        String expectedExceptionConstructor = "null";
        if (test.expected() != Test.None.class) {
            ClassWithJavascript exceptionClass = this.getConfig().getStjsClassResolver().resolve(test.expected().getName());
            expectedExceptionConstructor = exceptionClass.getJavascriptClassName();
        }
        resp.append("        var expectedException = " + expectedExceptionConstructor + ";\n");
        for (FrameworkMethod beforeMethod : attr.getBeforeMethods()) {
            resp.append("      stjsTest." + beforeMethod.getName() + "();\n");
        }
        resp.append("      stjsTest." + meth.getName() + "();\n");
        resp.append("      if(expectedException){\n");
        resp.append("        stjsResult = 'Expected an exception, but none was thrown';\n");
        resp.append("      }\n");
        resp.append("    }catch(ex){\n");
        resp.append("      if(!expectedException){\n");
        resp.append("        stjsResult = ex;\n");
        resp.append("      } else if (!stjs.isInstanceOf(ex.constructor,expectedException)){\n");
        resp.append("        stjsResult = ex;\n");
        resp.append("      }\n");
        resp.append("    }finally{\n");
        for (FrameworkMethod afterMethod : attr.getAfterMethods()) {
            resp.append("     stjsTest." + afterMethod.getName() + "();\n");
        }
        resp.append("      parent.reportResultAndRunNextTest(stjsResult, stjsResult.location);\n");
        resp.append("     }\n");
        resp.append("  }\n");
        resp.append("</script>\n");
        resp.append("</head>\n");
        resp.append("<body>\n");
        if (this.getConfig().isDebugJavaScript()) {
            resp.append("<div id='startSection'>\n");
            resp.append("  <h2>JavaScript debugging mode</h2>\n");
            resp.append("  <ul>\n");
            resp.append("    <li>Open your developer tools</li>\n");
            resp.append("    <li>Setup your breakpoints and debugging options</li>\n");
            resp.append("    <li>Start the test</li>\n");
            resp.append("  </ul>\n");
            resp.append("  <button onclick='runTest()'>\n");
            resp.append("    Start " + attr.getStjsClass().getJavaClass().getSimpleName() + "." + meth.getName() + "\n");
            resp.append("  </button>\n");
            resp.append("</div>\n");
        }
        if (attr.getHtmlFixture() != null) {
            if (!Strings.isNullOrEmpty((String)attr.getHtmlFixture().value())) {
                resp.append(attr.getHtmlFixture().value());
            } else if (!Strings.isNullOrEmpty((String)attr.getHtmlFixture().url())) {
                StringWriter writer = new StringWriter();
                this.getConfig().getResource(attr.getHtmlFixture().url()).copyTo(writer);
                resp.append(writer.toString());
            }
        }
        resp.append("</body>\n");
        resp.append("</html>\n");
        this.sendResponse(resp.toString(), exchange);
    }

    protected String httpPath(URI uri) {
        if ("webjar".equals(uri.getScheme())) {
            return "/webjars" + uri.getPath();
        }
        if ("classpath".equals(uri.getScheme())) {
            return uri.getPath();
        }
        return uri.toString();
    }

    public void sendNoMoreTestFixture(HttpExchange exchange) throws IOException {
        this.sendResponse("<html><body><h1>Tests completed!</h1></body></html>", exchange);
    }

    @Override
    public Set<Class<? extends AsyncProcess>> getSharedDependencies() {
        return LongPollingBrowser.processSet(HttpLongPollingServer.class);
    }

    protected void markAsDead() {
        this.isDead = true;
    }

    public void markAsDead(Throwable throwable, String userAgent) {
        this.isDead = true;
        this.methodUnderExecution.notifyExecutionResult(TestResult.deadBrowser(userAgent, throwable.getMessage()));
    }

    public long getId() {
        return this.id;
    }

    private static class TestClassCache {
        private TestClassCache() {
        }
    }
}

