/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.stjs.testing.driver.TestResource;
import org.webjars.WebJarAssetLocator;

public class TestResourceResolver {
    public static final String WEBJARS_ROOT = "/webjars/";
    private final ConcurrentHashMap<String, TestResource> cache = new ConcurrentHashMap();
    private final ClassLoader classLoader;
    private final WebJarAssetLocator webjarLocator;

    public TestResourceResolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.webjarLocator = new WebJarAssetLocator(WebJarAssetLocator.getFullPathIndex((Pattern)Pattern.compile(".*"), (ClassLoader[])new ClassLoader[]{classLoader}));
    }

    public TestResource resolveResource(String httpPath) throws URISyntaxException {
        URL resourceUrl;
        TestResource existing;
        TestResource resource = this.cache.get(httpPath);
        if (resource == null && (existing = this.cache.putIfAbsent(httpPath, resource = new TestResource(this.classLoader, httpPath, resourceUrl = this.resolveResourceUrl(httpPath)))) != null) {
            resource = existing;
        }
        return resource;
    }

    private URL resolveResourceUrl(String httpPath) {
        if (httpPath.startsWith(WEBJARS_ROOT)) {
            return this.resolveWebjarResourceName(httpPath);
        }
        return this.resolveClassPathResourceName(httpPath);
    }

    private URL resolveClassPathResourceName(String httpPath) {
        try {
            URI uri = new URI(httpPath);
            if (uri.getPath() == null) {
                throw new IllegalArgumentException("Wrong path in uri: " + httpPath);
            }
            return this.classLoader.getResource(uri.getPath().substring(1));
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException("Unable to parse uri: " + httpPath);
        }
    }

    private URL resolveWebjarResourceName(String httpPath) {
        String partialPath = httpPath.substring(WEBJARS_ROOT.length());
        String fullPath = this.webjarLocator.getFullPath(partialPath);
        return this.classLoader.getResource(fullPath);
    }
}

