/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Date;

public class TestResource {
    private final ClassLoader classLoader;
    private final String httpPath;
    private final URL resourceUrl;

    public TestResource(ClassLoader classLoader, String httpPath, URL resourceUrl) throws URISyntaxException {
        this.classLoader = classLoader;
        this.httpPath = httpPath;
        this.resourceUrl = resourceUrl;
    }

    public Date getModifiedDate() throws IOException {
        if (this.resourceUrl == null) {
            return new Date();
        }
        return this.withConnection(new ConnectionOperation<Date>(){

            @Override
            public Date doWithConnection(URLConnection connection) throws IOException {
                return new Date(connection.getLastModified());
            }
        });
    }

    public boolean copyTo(final Writer out) throws IOException {
        if (this.resourceUrl == null) {
            return false;
        }
        return this.withConnection(new ConnectionOperation<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean doWithConnection(URLConnection connection) throws IOException {
                InputStream is = connection.getInputStream();
                InputStreamReader reader = new InputStreamReader(is, Charset.forName("UTF-8"));
                try {
                    CharStreams.copy((Readable)reader, (Appendable)out);
                    out.flush();
                }
                finally {
                    Closeables.closeQuietly((Reader)reader);
                    Closeables.closeQuietly((InputStream)is);
                }
                return true;
            }
        });
    }

    public boolean copyTo(final HttpExchange exchange) throws IOException {
        if (this.resourceUrl == null) {
            exchange.sendResponseHeaders(404, -1L);
            return false;
        }
        return this.withConnection(new ConnectionOperation<Boolean>(){

            @Override
            public Boolean doWithConnection(URLConnection connection) throws IOException {
                try (InputStream is = connection.getInputStream();){
                    exchange.sendResponseHeaders(200, connection.getContentLengthLong());
                    OutputStream out = exchange.getResponseBody();
                    ByteStreams.copy((InputStream)is, (OutputStream)out);
                    out.flush();
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withConnection(ConnectionOperation<T> operation) throws IOException {
        URLConnection conn = this.resourceUrl.openConnection();
        conn.connect();
        try {
            T t = operation.doWithConnection(conn);
            return t;
        }
        finally {
            Closeables.closeQuietly((InputStream)conn.getInputStream());
        }
    }

    public String toString() {
        return "TestResource{classLoader=" + this.classLoader + ", httpPath='" + this.httpPath + '\'' + ", resourceUrl=" + this.resourceUrl + '}';
    }

    private static interface ConnectionOperation<T> {
        public T doWithConnection(URLConnection var1) throws IOException;
    }
}

