/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import org.junit.runners.model.TestClass;
import org.stjs.generator.ClassResolver;
import org.stjs.generator.DependencyCollector;
import org.stjs.testing.driver.TestClassAttributes;

public class TestClassAttributesRepository {
    private final ClassResolver classResolver;
    private final DependencyCollector dependencyCollector;
    private final ConcurrentMap<TestClass, TestClassAttributes> cache = new MapMaker().weakKeys().makeMap();

    public TestClassAttributesRepository(ClassResolver classResolver, DependencyCollector dependencyCollector) {
        this.classResolver = classResolver;
        this.dependencyCollector = dependencyCollector;
    }

    public TestClassAttributes getAttributes(TestClass testClass) {
        TestClassAttributes existing;
        TestClassAttributes attr = (TestClassAttributes)this.cache.get(testClass);
        if (attr == null && (existing = this.cache.putIfAbsent(testClass, attr = new TestClassAttributes(testClass, this.classResolver, this.dependencyCollector))) != null) {
            return existing;
        }
        return attr;
    }
}

