/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;
import org.stjs.generator.ClassResolver;
import org.stjs.generator.ClassWithJavascript;
import org.stjs.generator.DependencyCollector;
import org.stjs.javascript.functions.Function1;
import org.stjs.testing.annotation.HTMLFixture;
import org.stjs.testing.annotation.Scripts;
import org.stjs.testing.annotation.ScriptsAfter;
import org.stjs.testing.annotation.ScriptsBefore;

public class TestClassAttributes {
    private final List<FrameworkMethod> beforeMethods;
    private final List<FrameworkMethod> afterMethods;
    private final HTMLFixture htmlFixture;
    private final List<String> scripts;
    private final List<String> scriptsBefore;
    private final List<String> scriptsAfter;
    private final ClassWithJavascript stjsClass;
    private final List<ClassWithJavascript> dependencies;

    public TestClassAttributes(TestClass testClass, ClassResolver classResolver, DependencyCollector dependencyCollector) {
        this.beforeMethods = testClass.getAnnotatedMethods(Before.class);
        this.afterMethods = testClass.getAnnotatedMethods(After.class);
        this.stjsClass = classResolver.resolve(testClass.getName());
        this.htmlFixture = testClass.getJavaClass().getAnnotation(HTMLFixture.class);
        this.scripts = this.getScriptsPathes(testClass.getJavaClass(), Scripts.class, new Function1<Annotation, Collection<String>>(){

            public Collection<String> $invoke(Annotation annotation) {
                return Arrays.asList(((Scripts)Scripts.class.cast(annotation)).value());
            }
        });
        this.scriptsBefore = this.getScriptsPathes(testClass.getJavaClass(), ScriptsBefore.class, new Function1<Annotation, Collection<String>>(){

            public Collection<String> $invoke(Annotation annotation) {
                return Arrays.asList(((ScriptsBefore)ScriptsBefore.class.cast(annotation)).value());
            }
        });
        this.scriptsAfter = this.getScriptsPathes(testClass.getJavaClass(), ScriptsAfter.class, new Function1<Annotation, Collection<String>>(){

            public Collection<String> $invoke(Annotation annotation) {
                return Arrays.asList(((ScriptsAfter)ScriptsAfter.class.cast(annotation)).value());
            }
        });
        this.dependencies = dependencyCollector.orderAllDependencies(this.stjsClass);
    }

    public List<String> getScripts() {
        return this.scripts;
    }

    public List<String> getScriptsAfter() {
        return this.scriptsAfter;
    }

    public List<String> getScriptsBefore() {
        return this.scriptsBefore;
    }

    public List<FrameworkMethod> getAfterMethods() {
        return this.afterMethods;
    }

    public List<FrameworkMethod> getBeforeMethods() {
        return this.beforeMethods;
    }

    public List<ClassWithJavascript> getDependencies() {
        return this.dependencies;
    }

    public HTMLFixture getHtmlFixture() {
        return this.htmlFixture;
    }

    public ClassWithJavascript getStjsClass() {
        return this.stjsClass;
    }

    private List<String> getScriptsPathes(Class clazz, Class<? extends Annotation> anotClazz, Function1<Annotation, Collection<String>> caster) {
        LinkedList<Annotation> scriptsAnnots = this.accumulateAnnots(clazz, anotClazz, new LinkedList<Annotation>());
        LinkedHashSet scripts = new LinkedHashSet();
        int scriptsAnnotsSize = scriptsAnnots.size();
        for (int i = 0; i < scriptsAnnotsSize; ++i) {
            scripts.addAll((Collection)caster.$invoke((Object)scriptsAnnots.removeLast()));
        }
        return new ArrayList<String>(scripts);
    }

    private LinkedList<Annotation> accumulateAnnots(Class clazz, Class<? extends Annotation> annotation, LinkedList<Annotation> accum) {
        if (Object.class.equals((Object)clazz)) {
            return accum;
        }
        Annotation annot = clazz.getAnnotation(annotation);
        if (annot != null) {
            accum.add(annot);
        }
        return this.accumulateAnnots(clazz.getSuperclass(), annotation, accum);
    }
}

