/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import java.util.concurrent.CountDownLatch;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;
import org.stjs.testing.driver.TestResult;
import org.stjs.testing.driver.TestResultCollection;

public class MultiTestMethod {
    private final TestClass testClass;
    private final FrameworkMethod meth;
    private final CountDownLatch latch;
    private final TestResultCollection results;

    public MultiTestMethod(TestClass testClass, FrameworkMethod meth, int nBrowsers) {
        this.latch = new CountDownLatch(nBrowsers);
        this.meth = meth;
        this.testClass = testClass;
        this.results = new TestResultCollection(testClass.getName(), meth.getName());
    }

    public void notifyExecutionResult(TestResult result) {
        this.results.addResult(result);
        this.latch.countDown();
    }

    public TestResultCollection awaitExecutionResult() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return this.results;
    }

    public FrameworkMethod getMethod() {
        return this.meth;
    }

    public TestClass getTestClass() {
        return this.testClass;
    }

    public String getName() {
        return this.getMethod().getName();
    }

    public String toString() {
        return "MultiTestMethod [method=" + this.meth.getMethod() + "]";
    }
}

