/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import com.google.common.base.Charsets;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.runners.model.InitializationError;
import org.stjs.testing.driver.AsyncProcess;
import org.stjs.testing.driver.DriverConfiguration;
import org.stjs.testing.driver.MultiTestMethod;
import org.stjs.testing.driver.NoBodyHttpExchange;
import org.stjs.testing.driver.TestResource;
import org.stjs.testing.driver.TestResult;
import org.stjs.testing.driver.browser.LongPollingBrowser;

public class HttpLongPollingServer
implements AsyncProcess {
    private static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String NEXT_TEST_URI = "/getNextTest";
    public static final String BLANK_URI = "/about:blank";
    private final DriverConfiguration config;
    private final HttpServer httpServer;
    private final Map<Long, LongPollingBrowser> browsers = new ConcurrentHashMap<Long, LongPollingBrowser>();
    private final Map<Long, Long> selfAssignedBrowserIds = new ConcurrentHashMap<Long, Long>();
    private final Set<String> notFound = new HashSet<String>();

    public HttpLongPollingServer(DriverConfiguration config) throws InitializationError {
        this.config = config;
        InetSocketAddress address = new InetSocketAddress(config.getPort());
        try {
            this.httpServer = HttpServer.create(address, 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.httpServer.setExecutor(Executors.newFixedThreadPool(config.getBrowserCount() * 2, new ThreadFactory(){
            private AtomicInteger i = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("httpServer-" + this.i.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        }));
        this.httpServer.createContext("/", new AsyncHttpHandler());
        if (config.isDebugEnabled()) {
            System.out.println("Server session created");
        }
    }

    @Override
    public void start() throws InitializationError {
        this.httpServer.start();
        if (this.config.isDebugEnabled()) {
            System.out.println("Server session started");
        }
    }

    public long registerBrowserSession(LongPollingBrowser browser) {
        long id = this.browsers.size();
        this.browsers.put(id, browser);
        return id;
    }

    @Override
    public void stop() {
        this.httpServer.stop(5);
    }

    private final class AsyncHttpHandler
    implements HttpHandler {
        private AsyncHttpHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (HttpLongPollingServer.this.config.isDebugEnabled()) {
                System.out.println(exchange.getRequestMethod() + ": " + exchange.getRequestURI());
            }
            try {
                exchange.getResponseHeaders().add("Date", this.formatDateHeader(new Date()));
                exchange.getResponseHeaders().add("Connection", "Keep-Alive");
                exchange.getResponseHeaders().add("Server", "STJS");
                boolean dryRun = false;
                if (exchange.getRequestMethod().equals("HEAD") || exchange.getRequestMethod().equals("OPTIONS")) {
                    exchange = new NoBodyHttpExchange(exchange);
                    dryRun = true;
                }
                Map<String, String> params = this.parseQueryString(exchange.getRequestURI().getRawQuery());
                String path = exchange.getRequestURI().getPath();
                if (HttpLongPollingServer.NEXT_TEST_URI.equals(path)) {
                    this.handleNextTest(params, exchange, dryRun);
                } else if (HttpLongPollingServer.BLANK_URI.equals(path)) {
                    this.handleAboutBlank(exchange);
                } else {
                    this.handleResource(path, exchange);
                }
            }
            catch (Exception ex) {
                System.err.println("Error processing request:" + ex);
                ex.printStackTrace();
            }
            finally {
                exchange.close();
            }
        }

        private void handleAboutBlank(HttpExchange exchange) throws IOException {
            byte[] response = "<html></html>".getBytes("UTF-8");
            exchange.sendResponseHeaders(200, response.length);
            exchange.getResponseBody().write(response);
            exchange.getResponseBody().flush();
        }

        private void handleNextTest(Map<String, String> params, HttpExchange exchange, boolean dryRun) {
            MultiTestMethod completedMethod;
            long browserId = this.parseLong(params.get("browserId"), -1L);
            LongPollingBrowser browser = (LongPollingBrowser)HttpLongPollingServer.this.browsers.get(browserId);
            if (browser == null) {
                browser = this.selfAssignedBrowser(browserId);
            }
            if ((completedMethod = browser.getMethodUnderExecution()) != null) {
                if (HttpLongPollingServer.this.config.isDebugEnabled()) {
                    System.out.println("Server received test results for method " + completedMethod.toString() + " from browser " + browserId);
                }
                if (!dryRun) {
                    TestResult result = browser.buildResult(params, exchange);
                    completedMethod.notifyExecutionResult(result);
                }
            } else if (HttpLongPollingServer.this.config.isDebugEnabled()) {
                System.out.println("Server received request for the first test from browser " + browserId);
            }
            MultiTestMethod nextMethod = null;
            if (!dryRun) {
                nextMethod = browser.awaitNextTest();
            }
            if (nextMethod != null) {
                if (HttpLongPollingServer.this.config.isDebugEnabled()) {
                    System.out.println("Server is sending test for method " + nextMethod.toString() + " to browser " + browserId);
                }
                try {
                    browser.sendTestFixture(nextMethod, exchange);
                }
                catch (Exception e) {
                    browser.markAsDead(e, exchange.getRequestHeaders().getFirst("User-Agent"));
                    throw new RuntimeException(e);
                }
            }
            try {
                browser.sendNoMoreTestFixture(exchange);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        private synchronized LongPollingBrowser selfAssignedBrowser(long browserId) {
            Long correspondingId = (Long)HttpLongPollingServer.this.selfAssignedBrowserIds.get(browserId);
            if (correspondingId != null) {
                return (LongPollingBrowser)HttpLongPollingServer.this.browsers.get(correspondingId);
            }
            for (LongPollingBrowser browser : HttpLongPollingServer.this.browsers.values()) {
                if (HttpLongPollingServer.this.selfAssignedBrowserIds.containsValue(browser.getId())) continue;
                HttpLongPollingServer.this.selfAssignedBrowserIds.put(browserId, browser.getId());
                return browser;
            }
            throw new RuntimeException("More browser connections than configured browsers");
        }

        private synchronized void handleResource(String path, HttpExchange exchange) throws IOException, URISyntaxException {
            if (HttpLongPollingServer.this.notFound.contains(path)) {
                exchange.sendResponseHeaders(404, -1L);
                return;
            }
            if (path.endsWith(".js")) {
                exchange.getResponseHeaders().add("Content-Type", "text/javascript");
            } else if (path.endsWith(".html")) {
                exchange.getResponseHeaders().add("Content-Type", "text/html; charset=UTF-8");
            }
            String ifModifiedSinceHeader = exchange.getRequestHeaders().getFirst("If-Modified-Since");
            Date ifModifiedSince = this.parseDateHeader(ifModifiedSinceHeader);
            String cleanPath = path.replaceFirst("file:/+target", "target");
            TestResource resource = HttpLongPollingServer.this.config.getResource(cleanPath);
            Date lastModified = resource.getModifiedDate();
            exchange.getResponseHeaders().add("Last-Modified", this.formatDateHeader(lastModified));
            if (ifModifiedSince != null && !lastModified.after(ifModifiedSince)) {
                exchange.sendResponseHeaders(304, -1L);
                return;
            }
            if (!resource.copyTo(exchange)) {
                HttpLongPollingServer.this.notFound.add(path);
                System.err.println(resource + " was not found in classpath");
            }
        }

        private Map<String, String> parseQueryString(String query) {
            String[] nameValues;
            HashMap<String, String> params = new HashMap<String, String>();
            if (query == null) {
                return params;
            }
            for (String nv : nameValues = query.split("&")) {
                String[] x = nv.split("=");
                if (x.length != 2) continue;
                try {
                    params.put(x[0], URLDecoder.decode(x[1], Charsets.UTF_8.name()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            return params;
        }

        private Date parseDateHeader(String header) {
            if (header == null) {
                return null;
            }
            SimpleDateFormat df = new SimpleDateFormat(HttpLongPollingServer.HTTP_DATE_FORMAT, Locale.ENGLISH);
            try {
                return df.parse(header);
            }
            catch (ParseException e) {
                System.err.println("Cannot parse date header:" + e);
                return null;
            }
        }

        private String formatDateHeader(Date date) {
            SimpleDateFormat df = new SimpleDateFormat(HttpLongPollingServer.HTTP_DATE_FORMAT, Locale.ENGLISH);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            return df.format(date);
        }

        private long parseLong(String s, long defaultValue) {
            if (s == null) {
                return defaultValue;
            }
            try {
                return Long.parseLong(s);
            }
            catch (Exception ex) {
                return defaultValue;
            }
        }
    }
}

