/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import org.stjs.testing.driver.STJSTestDriverRunner;

public class WebAppClassLoader
extends URLClassLoader {
    private final boolean debugEnabled;
    public static final File WEBAPP_DIR = new File("src/main/webapp");

    public WebAppClassLoader(URL[] urls, ClassLoader parent, boolean debugEnabled) {
        super(urls, parent);
        this.debugEnabled = debugEnabled;
        try {
            STJSTestDriverRunner.targetDirectory.mkdirs();
            this.addURL(STJSTestDriverRunner.targetDirectory.toURI().toURL());
            this.addURL(WEBAPP_DIR.toURI().toURL());
            this.addCurrentProjectSTJSClasspath();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void addCurrentProjectSTJSClasspath() {
        try {
            Enumeration<URL> cpFiles = this.getResources("stjs.cp");
            while (cpFiles.hasMoreElements()) {
                URL cpFile = cpFiles.nextElement();
                if (!"file".equals(cpFile.getProtocol())) continue;
                for (String cp : Files.readLines((File)new File(cpFile.getPath()), (Charset)Charset.defaultCharset())) {
                    this.addURL(new File(cp).toURI().toURL());
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void addURL(URL url) {
        if (this.debugEnabled) {
            System.out.println("Added to test CLASSPATH: " + url);
        }
        super.addURL(url);
    }
}

