/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import org.stjs.generator.sourcemap.JavascriptToJava;

public class TestResult {
    private final String message;
    private final String location;
    private final String userAgent;
    private final boolean isAssert;
    private final boolean dead;

    public TestResult(String userAgent, String message, String location, boolean isAssert) {
        this(userAgent, message, location, isAssert, false);
    }

    public TestResult(String userAgent, String message, String location, boolean isAssert, boolean dead) {
        this.userAgent = userAgent;
        this.message = message;
        this.location = location;
        this.isAssert = isAssert;
        this.dead = dead;
    }

    public static TestResult deadBrowser(String userAgent, String message) {
        return new TestResult(userAgent, message, null, false, true);
    }

    public String getMessage() {
        return this.message;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isOk() {
        return "OK".equals(this.message);
    }

    public boolean isDead() {
        return this.dead;
    }

    public Throwable buildException(ClassLoader testClassLoader) {
        if (this.dead) {
            return new Error("Browser is dead or unable to contact back the STJS JUnit runner: " + this.message + ", user agent: " + this.userAgent);
        }
        Object ex = this.isAssert ? new AssertionError((Object)(this.message + ", user agent: " + this.userAgent)) : new RuntimeException(this.message + ", user agent: " + this.userAgent);
        StackTraceElement[] stackTrace = new JavascriptToJava(testClassLoader).buildStacktrace(this.location, ";");
        ((Throwable)ex).setStackTrace(stackTrace);
        return ex;
    }

    public String toString() {
        return "TestResult [message=" + this.message + ", location=" + this.location + ", userAgent=" + this.userAgent + "]";
    }
}

