/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import com.google.common.io.Closeables;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.stjs.testing.driver.WebAppClassLoader;
import org.stjs.testing.driver.browser.Browser;
import org.stjs.testing.driver.browser.ChromeBrowser;
import org.stjs.testing.driver.browser.DesktopDefaultBrowser;
import org.stjs.testing.driver.browser.FirefoxBrowser;
import org.stjs.testing.driver.browser.HeadlessChromeBrowser;
import org.stjs.testing.driver.browser.HeadlessFirefoxBrowser;
import org.stjs.testing.driver.browser.PhantomjsBrowser;
import org.stjs.testing.driver.browser.RemoteBrowser;
import org.stjs.testing.driver.browser.RhinoBrowser;

public class DriverConfiguration {
    private static final String FILE_NAME = "/stjs-test.properties";
    private static final String PROP_CONFIG = "stjs.test.config";
    private static final String PROP_PORT = "stjs.test.port";
    private static final String PROP_WAIT_FOR_BROWSER = "stjs.test.wait";
    private static final String PROP_SKIP_IF_NO_BROWSER = "stjs.test.skipIfNoBrowser";
    private static final String PROP_START_BROWSER = "stjs.test.startBrowser";
    private static final String PROP_BROWSER_COUNT = "stjs.test.browserCount";
    private static final String PROP_BROWSERS = "stjs.test.browsers";
    private static final String PROP_TEST_TIMEOUT = "stjs.test.testTimeout";
    private static final String PROP_DEBUG = "stjs.test.debug";
    private int port;
    private int waitForBrowser;
    private boolean skipIfNoBrowser;
    private boolean startBrowser;
    private int testTimeout;
    private boolean debugEnabled;
    private List<Browser> browsers;
    private final ClassLoader classLoader;
    private Properties props;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public DriverConfiguration(Class<?> klass) {
        InputStream in;
        block11: {
            this.port = 8055;
            this.waitForBrowser = 10;
            this.skipIfNoBrowser = false;
            this.startBrowser = true;
            this.testTimeout = 2;
            this.debugEnabled = false;
            in = null;
            this.props = new Properties();
            try {
                in = klass.getResourceAsStream(this.getConfigFileLocation());
                if (in == null) break block11;
                this.props.load(in);
            }
            catch (IOException iOException) {
                Closeables.closeQuietly((InputStream)in);
                catch (Throwable throwable) {
                    Closeables.closeQuietly(in);
                    throw throwable;
                }
            }
        }
        Closeables.closeQuietly((InputStream)in);
        this.props.putAll((Map<?, ?>)System.getProperties());
        if (this.props.get(PROP_PORT) != null) {
            this.port = Integer.parseInt(this.props.getProperty(PROP_PORT));
        }
        if (this.props.get(PROP_WAIT_FOR_BROWSER) != null) {
            this.waitForBrowser = Integer.parseInt(this.props.getProperty(PROP_WAIT_FOR_BROWSER));
        }
        if (this.props.get(PROP_SKIP_IF_NO_BROWSER) != null) {
            this.skipIfNoBrowser = Boolean.parseBoolean(this.props.getProperty(PROP_SKIP_IF_NO_BROWSER));
        }
        if (this.props.get(PROP_START_BROWSER) != null) {
            this.startBrowser = Boolean.parseBoolean(this.props.getProperty(PROP_START_BROWSER));
        }
        if (this.props.get(PROP_TEST_TIMEOUT) != null) {
            this.testTimeout = Integer.parseInt(this.props.getProperty(PROP_TEST_TIMEOUT));
        }
        if (this.props.get(PROP_BROWSER_COUNT) != null) {
            System.out.println("Configuration property stjs.test.browserCount is now ignored, use stjs.test.browsers instead");
        }
        if (this.props.get(PROP_DEBUG) != null) {
            this.debugEnabled = Boolean.parseBoolean(this.props.getProperty(PROP_DEBUG));
        }
        this.classLoader = new WebAppClassLoader(new URL[0], klass.getClassLoader(), this.debugEnabled);
        this.browsers = this.instantiateBrowsers();
    }

    private String getConfigFileLocation() {
        String location = System.getProperties().getProperty(PROP_CONFIG);
        if (location == null) {
            location = FILE_NAME;
        }
        return location;
    }

    private List<Browser> instantiateBrowsers() {
        if (this.props.getProperty(PROP_BROWSERS) == null) {
            return Arrays.asList(new DesktopDefaultBrowser(this));
        }
        String[] browserNames = this.props.getProperty(PROP_BROWSERS).split(",");
        this.browsers = new ArrayList<Browser>(browserNames.length);
        for (String browserName : browserNames) {
            Browser browser = BrowserBuilder.build(browserName.trim(), this);
            if (browser == null) continue;
            this.browsers.add(browser);
        }
        return this.browsers;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getWaitForBrowser() {
        return this.waitForBrowser;
    }

    public void setWaitForBrowser(int waitForBrowser) {
        this.waitForBrowser = waitForBrowser;
    }

    public boolean isSkipIfNoBrowser() {
        return this.skipIfNoBrowser;
    }

    public void setSkipIfNoBrowser(boolean skipIfNoBrowser) {
        this.skipIfNoBrowser = skipIfNoBrowser;
    }

    public boolean isStartBrowser() {
        return this.startBrowser;
    }

    public void setStartBrowser(boolean startBrowser) {
        this.startBrowser = startBrowser;
    }

    public int getTestTimeout() {
        return this.testTimeout;
    }

    public void setTestTimeout(int testTimeout) {
        this.testTimeout = testTimeout;
    }

    public int getBrowserCount() {
        return this.browsers.size();
    }

    public List<Browser> getBrowsers() {
        return this.browsers;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public String getProperty(String name, String defaultValue) {
        return this.props.getProperty(name, defaultValue);
    }

    public URL getServerURL() {
        try {
            return new URL("http", "localhost", this.port, "/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum BrowserBuilder {
        PHANTOMJS("phantomjs", PhantomjsBrowser.class),
        DESKTOP_DEFAULT("desktopDefault", DesktopDefaultBrowser.class),
        FIREFOX("firefox", FirefoxBrowser.class),
        CHROME("chrome", ChromeBrowser.class),
        HEADLESS_FIREFOX("headlessFirefox", HeadlessFirefoxBrowser.class),
        HEADLESS_CHROME("headlessChrome", HeadlessChromeBrowser.class),
        REMOTE("remote", RemoteBrowser.class),
        RHINO("rhino", RhinoBrowser.class);

        String name;
        Class<? extends Browser> clazz;

        private BrowserBuilder(String name, Class<? extends Browser> clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        static Browser build(String browserName, DriverConfiguration config) {
            BrowserBuilder builder = BrowserBuilder.forName(browserName);
            if (builder == null) {
                System.out.println("Unable to create browser \"" + browserName + "\": Unknown browser name");
                return null;
            }
            try {
                Constructor<? extends Browser> cons = builder.clazz.getConstructor(DriverConfiguration.class);
                return cons.newInstance(config);
            }
            catch (Exception e) {
                System.out.println("Unable to create browser \"" + browserName + "\": " + e.getMessage());
                return null;
            }
        }

        static BrowserBuilder forName(String name) {
            for (BrowserBuilder builder : BrowserBuilder.values()) {
                if (!builder.name.equals(name)) continue;
                return builder;
            }
            return null;
        }
    }
}

