/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.sun.net.httpserver.HttpExchange;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;

public class StreamUtils {
    private StreamUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(ClassLoader classLoader, String url, Writer out) throws IOException, URISyntaxException {
        URI uri = new URI(url);
        if (uri.getPath() == null) {
            throw new IllegalArgumentException("Wrong path in uri:" + url);
        }
        InputStream is = classLoader.getResourceAsStream(uri.getPath().substring(1));
        if (is == null) {
            return false;
        }
        try (InputStreamReader reader = new InputStreamReader(is, Charset.forName("UTF-8"));){
            CharStreams.copy((Readable)reader, (Appendable)out);
            out.flush();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getResourceSize(ClassLoader classLoader, String path) throws IOException {
        InputStream is = classLoader.getResourceAsStream(path);
        try {
            long n = 0L;
            while (is.read() >= 0) {
                ++n;
            }
            long l = n;
            return l;
        }
        finally {
            Closeables.closeQuietly((InputStream)is);
        }
    }

    public static Date getResourceModifiedDate(ClassLoader classLoader, String url) throws URISyntaxException {
        URI uri = new URI(url);
        if (uri.getPath() == null) {
            throw new IllegalArgumentException("Wrong path in uri:" + url);
        }
        URL resourceUrl = classLoader.getResource(uri.getPath().substring(1));
        if (resourceUrl == null) {
            return new Date();
        }
        if (resourceUrl.getProtocol().equals("file")) {
            File file = new File(resourceUrl.getFile());
            return new Date(file.lastModified());
        }
        if (resourceUrl.getProtocol().equals("jar")) {
            String fullPath = resourceUrl.getFile();
            String jarFile = fullPath.replace("file:", "").replaceAll("!.+", "");
            File file = new File(jarFile);
            return new Date(file.lastModified());
        }
        return new Date();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(ClassLoader classLoader, String url, HttpExchange exchange) throws IOException, URISyntaxException {
        URI uri = new URI(url);
        if (uri.getPath() == null) {
            throw new IllegalArgumentException("Wrong path in uri:" + url);
        }
        InputStream is = classLoader.getResourceAsStream(uri.getPath().substring(1));
        if (is == null) {
            exchange.sendResponseHeaders(404, -1L);
            return false;
        }
        try {
            exchange.sendResponseHeaders(200, StreamUtils.getResourceSize(classLoader, uri.getPath().substring(1)));
            OutputStream out = exchange.getResponseBody();
            ByteStreams.copy((InputStream)is, (OutputStream)out);
            out.flush();
        }
        finally {
            is.close();
        }
        return true;
    }
}

