/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver.browser;

import com.google.common.base.Strings;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.stjs.generator.BridgeClass;
import org.stjs.generator.ClassWithJavascript;
import org.stjs.generator.DependencyCollection;
import org.stjs.generator.Generator;
import org.stjs.testing.annotation.HTMLFixture;
import org.stjs.testing.annotation.Scripts;
import org.stjs.testing.annotation.ScriptsAfter;
import org.stjs.testing.annotation.ScriptsBefore;
import org.stjs.testing.driver.AsyncProcess;
import org.stjs.testing.driver.DriverConfiguration;
import org.stjs.testing.driver.HttpLongPollingServer;
import org.stjs.testing.driver.JUnitSession;
import org.stjs.testing.driver.MultiTestMethod;
import org.stjs.testing.driver.StreamUtils;
import org.stjs.testing.driver.TestResult;
import org.stjs.testing.driver.browser.AbstractBrowser;

public abstract class LongPollingBrowser
extends AbstractBrowser {
    private final Exchanger<MultiTestMethod> exchanger = new Exchanger();
    private volatile MultiTestMethod methodUnderExecution = null;
    private long id;
    private volatile boolean isDead = false;

    public LongPollingBrowser(DriverConfiguration config) {
        super(config);
    }

    protected String getStartPageUri(long browserId, boolean persistent) {
        return "start.html?browserId=" + browserId + "&persistent=" + persistent;
    }

    protected String getStartPageUrl(long browserId, boolean persistent) {
        return this.getConfig().getServerURL() + this.getStartPageUri(browserId, persistent);
    }

    protected void registerWithLongPollingServer() {
        this.id = JUnitSession.getInstance().getDependency(HttpLongPollingServer.class).registerBrowserSession(this);
        if (this.getConfig().isDebugEnabled()) {
            System.out.println("Browser " + this.id + " is " + this.getClass().getSimpleName());
        }
    }

    @Override
    public void start() throws InitializationError {
        try {
            this.doStart();
        }
        catch (InitializationError ie) {
            this.markAsDead();
            throw ie;
        }
        catch (Throwable t) {
            this.markAsDead();
            throw new InitializationError(t);
        }
    }

    protected abstract void doStart() throws InitializationError;

    public MultiTestMethod awaitNextTest() {
        try {
            if (this.getConfig().isDebugEnabled()) {
                System.out.println("Browser " + this.id + " is waiting for a new test");
            }
            this.methodUnderExecution = this.exchanger.exchange(null);
            if (this.getConfig().isDebugEnabled()) {
                if (this.methodUnderExecution != null) {
                    System.out.println("Browser " + this.id + " has picked up the test " + this.methodUnderExecution.getMethod().getMethod());
                } else {
                    System.out.println("Browser " + this.id + " has no more tests");
                }
            }
            return this.methodUnderExecution;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void executeTest(MultiTestMethod method) {
        if (this.isDead) {
            this.reportAsDead(method);
            return;
        }
        try {
            if (this.getConfig().isDebugEnabled()) {
                System.out.println("Test " + method.getMethod().getMethod() + " is available for browser " + this.id);
            }
            this.exchanger.exchange(method, this.getConfig().getTestTimeout(), TimeUnit.SECONDS);
            if (this.getConfig().isDebugEnabled()) {
                System.out.println("Browser " + this.id + " has picked up the new test");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            this.markAsDead();
            this.reportAsDead(method);
        }
    }

    private void reportAsDead(MultiTestMethod method) {
        method.notifyExecutionResult(new TestResult(this.getClass().getSimpleName(), "Browser is dead", null, false));
    }

    @Override
    public void notifyNoMoreTests() {
        if (this.isDead) {
            return;
        }
        try {
            if (this.getConfig().isDebugEnabled()) {
                System.out.println("Browser " + this.id + " has been notified that no more tests are coming");
            }
            this.exchanger.exchange(null, this.getConfig().getTestTimeout(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            this.markAsDead();
        }
    }

    public MultiTestMethod getMethodUnderExecution() {
        return this.methodUnderExecution;
    }

    private String getTypeName(Class<?> clazz) {
        return clazz.getSimpleName();
    }

    public void sendTestFixture(MultiTestMethod meth, HttpExchange exchange) throws Exception {
        Class testClass = meth.getTestClass().getJavaClass();
        Method method = meth.getMethod().getMethod();
        ClassWithJavascript stjsClass = new Generator().getExistingStjsClass(this.getConfig().getClassLoader(), testClass);
        List beforeMethods = meth.getTestClass().getAnnotatedMethods(Before.class);
        List afterMethods = meth.getTestClass().getAnnotatedMethods(After.class);
        HTMLFixture htmlFixture = testClass.getAnnotation(HTMLFixture.class);
        Scripts addedScripts = testClass.getAnnotation(Scripts.class);
        ScriptsBefore addedScriptsBefore = testClass.getAnnotation(ScriptsBefore.class);
        ScriptsAfter addedScriptsAfter = testClass.getAnnotation(ScriptsAfter.class);
        Test test = (Test)meth.getMethod().getAnnotation(Test.class);
        StringBuilder resp = new StringBuilder(8192);
        resp.append("<html>\n");
        resp.append("<head>\n");
        this.appendScriptTag(resp, "/stjs.js");
        this.appendScriptTag(resp, "/junit.js");
        resp.append("<script language='javascript'>stjs.mainCallDisabled=true;</script>\n");
        if (addedScripts != null) {
            for (String script : addedScripts.value()) {
                this.appendScriptTag(resp, script);
            }
        }
        if (addedScriptsBefore != null) {
            for (String script : addedScriptsBefore.value()) {
                this.appendScriptTag(resp, script);
            }
        }
        LinkedHashSet<URI> jsFiles = new LinkedHashSet<URI>();
        for (ClassWithJavascript dep : new DependencyCollection(stjsClass).orderAllDependencies(this.getConfig().getClassLoader())) {
            if (addedScripts != null && dep instanceof BridgeClass) {
                System.out.println("WARNING: You're using @Scripts deprecated annotation that disables the automatic inclusion of the Javascript files of the bridges you're using! Please consider using @ScriptsBefore and/or @ScriptsAfter instead.");
                continue;
            }
            for (URI file : dep.getJavascriptFiles()) {
                jsFiles.add(file);
            }
        }
        for (URI file : jsFiles) {
            this.appendScriptTag(resp, file.toString());
        }
        if (addedScriptsAfter != null) {
            for (String script : addedScriptsAfter.value()) {
                this.appendScriptTag(resp, script);
            }
        }
        resp.append("<script language='javascript'>\n");
        resp.append("  window.onload=function(){\n");
        resp.append("    Assert=window;\n");
        String testedClassName = testClass.getSimpleName();
        resp.append("    parent.startingTest('" + testedClassName + "', '" + method.getName() + "');");
        resp.append("    var stjsTest = new " + testedClassName + "();\n");
        resp.append("    var stjsResult = 'OK';\n");
        resp.append("    var expectedException = " + (test.expected() != Test.None.class ? this.getTypeName(test.expected()) : null) + ";\n");
        resp.append("    try{\n");
        for (FrameworkMethod beforeMethod : beforeMethods) {
            resp.append("      stjsTest." + beforeMethod.getName() + "();\n");
        }
        resp.append("      stjsTest." + method.getName() + "();\n");
        resp.append("      if(expectedException){\n");
        resp.append("        stjsResult = 'Expected an exception, but none was thrown';\n");
        resp.append("      }\n");
        resp.append("    }catch(ex){\n");
        resp.append("      if(!expectedException){\n");
        resp.append("        stjsResult = ex;\n");
        resp.append("      } else if (!stjs.isInstanceOf(ex.constructor,expectedException)){\n");
        resp.append("        stjsResult = ex;\n");
        resp.append("      }\n");
        resp.append("    }finally{\n");
        for (FrameworkMethod afterMethod : afterMethods) {
            resp.append("     stjsTest." + afterMethod.getName() + "();\n");
        }
        resp.append("      parent.reportResultAndRunNextTest(stjsResult, stjsResult.location);\n");
        resp.append("     }\n");
        resp.append("  }\n");
        resp.append("</script>\n");
        resp.append("</head>\n");
        resp.append("<body>\n");
        if (htmlFixture != null) {
            if (!Strings.isNullOrEmpty((String)htmlFixture.value())) {
                resp.append(htmlFixture.value());
            } else if (!Strings.isNullOrEmpty((String)htmlFixture.url())) {
                StringWriter writer = new StringWriter();
                StreamUtils.copy(this.getConfig().getClassLoader(), htmlFixture.url(), writer);
                resp.append(writer.toString());
            }
        }
        resp.append("</body>\n");
        resp.append("</html>\n");
        this.sendResponse(resp.toString(), exchange);
    }

    public void sendNoMoreTestFixture(HttpExchange exchange) throws IOException {
        this.sendResponse("<html><body><h1>Tests completed!</h1></body></html>", exchange);
    }

    @Override
    public Set<Class<? extends AsyncProcess>> getSharedDependencies() {
        return LongPollingBrowser.processSet(HttpLongPollingServer.class);
    }

    protected void markAsDead() {
        this.isDead = true;
    }

    public void markAsDead(Throwable throwable, String userAgent) {
        this.isDead = true;
        this.methodUnderExecution.notifyExecutionResult(new TestResult(userAgent, throwable.getMessage(), null, false));
    }

    public long getId() {
        return this.id;
    }
}

