/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.stjs.testing.driver.AsyncProcess;
import org.stjs.testing.driver.DriverConfiguration;
import org.stjs.testing.driver.STJSTestDriverRunner;
import org.stjs.testing.driver.TestResultCollection;
import org.stjs.testing.driver.browser.Browser;

public class JUnitSession {
    private static JUnitSession instance = null;
    private DriverConfiguration config;
    private volatile boolean initFailed = false;
    private List<Browser> browsers;
    private HashMap<Class<? extends AsyncProcess>, AsyncProcess> sharedDependencies = new HashMap();

    public static JUnitSession getInstance() {
        if (instance == null) {
            instance = new JUnitSession();
        }
        return instance;
    }

    private JUnitSession() {
    }

    private void init(Class<?> testClassSample) throws InitializationError {
        if (this.config != null) {
            return;
        }
        if (this.initFailed) {
            throw new InitializationError("Session initialization failed previously. Not trying again.");
        }
        try {
            this.config = new DriverConfiguration(testClassSample);
            this.addShutdownHook();
            this.initBrowsers();
            this.initBrowserDependencies();
            this.startBrowserDependencies();
            this.startBrowsers();
        }
        catch (Throwable e) {
            JUnitSession.printStackTrace(e);
            this.reset();
            this.initFailed = true;
            throw new InitializationError(e);
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                JUnitSession.this.reset();
            }
        }));
    }

    private void initBrowsers() {
        this.browsers = new ArrayList<Browser>(this.config.getBrowsers());
    }

    private void initBrowserDependencies() throws InitializationError {
        HashSet<Class<? extends AsyncProcess>> deps = new HashSet<Class<? extends AsyncProcess>>();
        for (Browser browser : this.config.getBrowsers()) {
            deps.addAll(browser.getSharedDependencies());
        }
        for (Class clazz : deps) {
            this.sharedDependencies.put(clazz, this.initBrowserDependency(clazz));
        }
    }

    private AsyncProcess initBrowserDependency(Class<? extends AsyncProcess> dep) throws InitializationError {
        try {
            Constructor<? extends AsyncProcess> cons = dep.getConstructor(DriverConfiguration.class);
            return cons.newInstance(this.config);
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor<? extends AsyncProcess> cons = dep.getConstructor(new Class[0]);
                return cons.newInstance(new Object[0]);
            }
            catch (Exception e2) {
                throw new InitializationError((Throwable)e2);
            }
        }
        catch (Exception e) {
            throw new InitializationError((Throwable)e);
        }
    }

    private void startBrowserDependencies() throws InitializationError {
        this.startInParallel(this.sharedDependencies.values());
    }

    private void startBrowsers() throws InitializationError {
        this.startInParallel(this.browsers);
    }

    private void startInParallel(Collection<? extends AsyncProcess> processes) throws InitializationError {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        final CopyOnWriteArrayList errors = new CopyOnWriteArrayList();
        for (final AsyncProcess asyncProcess : processes) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        asyncProcess.start();
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                }
            });
            t.start();
            threads.add(t);
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new InitializationError((Throwable)e);
            }
        }
        if (!errors.isEmpty()) {
            throw new InitializationError(errors);
        }
    }

    private void reset() {
        this.config = null;
        for (Browser browser : this.browsers) {
            try {
                browser.notifyNoMoreTests();
                browser.stop();
            }
            catch (Throwable e) {
                JUnitSession.printStackTrace(e);
            }
        }
        this.browsers.clear();
        for (AsyncProcess dep : this.sharedDependencies.values()) {
            try {
                dep.stop();
            }
            catch (Throwable e) {
                JUnitSession.printStackTrace(e);
            }
        }
        this.sharedDependencies.clear();
    }

    public void runnerInstantiated(STJSTestDriverRunner runner) throws InitializationError {
        if (this.config == null) {
            this.init(runner.getTestClass().getJavaClass());
        }
        if (this.config.isDebugEnabled()) {
            System.out.println("Runner for class " + runner.getTestClass().getJavaClass().getName() + " is starting");
        }
    }

    public void testStarting(STJSTestDriverRunner runner, FrameworkMethod method) {
        if (this.config.isDebugEnabled()) {
            System.out.println("test " + method.getMethod() + " is starting");
        }
    }

    public void testCompleted(STJSTestDriverRunner runner, FrameworkMethod method, TestResultCollection result) {
        if (this.config.isDebugEnabled()) {
            System.out.println("test " + method.getMethod() + " is completed");
        }
    }

    public void runnerCompleted(STJSTestDriverRunner runner) {
        if (this.config.isDebugEnabled()) {
            System.out.println("Runner for class " + runner.getTestClass().getJavaClass().getName() + " has completed");
        }
    }

    public DriverConfiguration getConfig() {
        return this.config;
    }

    public List<Browser> getBrowsers() {
        return this.browsers;
    }

    public <T> T getDependency(Class<T> depencencyType) {
        return (T)this.sharedDependencies.get(depencencyType);
    }

    private static void printStackTrace(Throwable t) {
        JUnitSession.printStackTrace(t, System.err);
    }

    private static void printStackTrace(Throwable t, PrintStream out) {
        if (t instanceof InitializationError) {
            out.println(t);
        } else {
            out.println(t);
            for (StackTraceElement elem : t.getStackTrace()) {
                out.println("\tat " + elem);
            }
        }
        JUnitSession.printCauses(t, "", out);
    }

    private static void printCauses(Throwable caused, String prefix, PrintStream out) {
        if (caused instanceof InitializationError) {
            InitializationError ie = (InitializationError)caused;
            List causes = ie.getCauses();
            if (causes != null && !causes.isEmpty()) {
                System.err.println(prefix + "Caused by " + causes.size() + " exceptions:");
                for (Throwable cause : causes) {
                    JUnitSession.printCauseStackTrace(cause, caused.getStackTrace(), "\t" + prefix, out);
                }
            }
        } else if (caused.getCause() != null) {
            JUnitSession.printCauseStackTrace(caused.getCause(), caused.getStackTrace(), prefix, out);
        }
    }

    private static void printCauseStackTrace(Throwable cause, StackTraceElement[] causedTrace, String prefix, PrintStream out) {
        StackTraceElement[] trace = cause.getStackTrace();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        out.println(prefix + "Caused by: " + cause);
        for (int i = 0; i <= m; ++i) {
            out.println(prefix + "\tat " + trace[i]);
        }
        if (framesInCommon != 0) {
            out.println(prefix + "\t... " + framesInCommon + " more");
        }
        JUnitSession.printCauses(cause, prefix, out);
    }
}

