/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver.browser;

import com.sun.net.httpserver.HttpExchange;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.runners.model.InitializationError;
import org.openqa.selenium.browserlaunchers.locators.BrowserInstallation;
import org.openqa.selenium.browserlaunchers.locators.SingleBrowserLocator;
import org.stjs.testing.driver.AsyncProcess;
import org.stjs.testing.driver.DriverConfiguration;
import org.stjs.testing.driver.HttpLongPollingServer;
import org.stjs.testing.driver.TestResult;
import org.stjs.testing.driver.browser.LongPollingBrowser;

public class PhantomjsBrowser
extends LongPollingBrowser {
    public static final String PROP_PHANTOMJS_BIN = "phantomjs.bin";
    private File tempBootstrapJs;

    public PhantomjsBrowser(DriverConfiguration config) {
        super(config);
    }

    @Override
    public void doStart() throws InitializationError {
        this.registerWithLongPollingServer();
        try {
            this.tempBootstrapJs = this.unpackBootstrap();
            String executableName = this.getConfig().getProperty(PROP_PHANTOMJS_BIN);
            if (executableName == null) {
                BrowserInstallation installation = new Locator().findBrowserLocation();
                if (installation == null) {
                    throw new InitializationError("phantomjs could not be found in the path!\nPlease add the directory containing 'phantomjs' or 'phantomjs.exe' to your PATH environment\nvariable, or explicitly specify a path to phantomjs in stjs-test.properties like this:\nphantomjs.bin=/blah/blah/phantomjs");
                }
                executableName = installation.launcherFilePath();
            }
            new ProcessBuilder(executableName, "--web-security=no", this.tempBootstrapJs.getAbsolutePath(), Long.toString(this.getId()), this.getConfig().getServerURL().toString()).start();
            if (this.getConfig().isDebugEnabled()) {
                System.out.println("Started phantomjs");
            }
        }
        catch (IOException e) {
            throw new InitializationError((Throwable)e);
        }
    }

    @Override
    public void sendNoMoreTestFixture(HttpExchange exchange) throws IOException {
        byte[] response = "<html><head><script language='javascript'>parent.phantom.exit()</script></head></html>".getBytes("UTF-8");
        exchange.sendResponseHeaders(200, response.length);
        OutputStream output = exchange.getResponseBody();
        output.write(response);
        output.flush();
    }

    @Override
    public void stop() {
        this.tempBootstrapJs.delete();
    }

    private File unpackBootstrap() throws IOException {
        int bytesRead;
        File tmp = File.createTempFile("phantomjs", null);
        InputStream in = this.getClass().getResourceAsStream("/phantomjs-bootstrap.js");
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmp));
        byte[] buffer = new byte[8192];
        while ((bytesRead = in.read(buffer)) > 0) {
            out.write(buffer, 0, bytesRead);
        }
        in.close();
        out.close();
        return tmp;
    }

    @Override
    public TestResult buildResult(Map<String, String> queryStringParameters, HttpExchange exchange) {
        String userAgent = exchange.getRequestHeaders().getFirst("User-Agent");
        String result = queryStringParameters.get("result");
        String location = queryStringParameters.get("location");
        String isAssert = queryStringParameters.get("isAssert");
        if (this.getConfig().isDebugEnabled()) {
            System.out.println("Result was: " + result + ", at " + location + ", from " + userAgent);
        }
        return new TestResult(userAgent, result, location, "true".equals(isAssert));
    }

    @Override
    public Set<Class<? extends AsyncProcess>> getSharedDependencies() {
        HashSet<Class<? extends AsyncProcess>> dep = new HashSet<Class<? extends AsyncProcess>>();
        dep.add(HttpLongPollingServer.class);
        return dep;
    }

    private static class Locator
    extends SingleBrowserLocator {
        private Locator() {
        }

        protected String[] standardlauncherFilenames() {
            return new String[]{"phantomjs", "phantomjs.exe"};
        }

        protected String[] usualLauncherLocations() {
            return new String[]{"/usr/bin"};
        }

        protected String seleniumBrowserName() {
            return "phantomjs";
        }

        protected String browserPathOverridePropertyName() {
            return "phantomjs";
        }

        protected String browserName() {
            return "phantomjs";
        }
    }
}

