/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver.browser;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.runners.model.InitializationError;
import org.openqa.selenium.browserlaunchers.locators.BrowserLocator;
import org.stjs.testing.driver.AsyncProcess;
import org.stjs.testing.driver.DriverConfiguration;
import org.stjs.testing.driver.TestResult;
import org.stjs.testing.driver.browser.Browser;

public abstract class AbstractBrowser
implements Browser {
    private DriverConfiguration config;

    public AbstractBrowser(DriverConfiguration config) {
        this.config = config;
    }

    protected void startProcess(BrowserLocator locator, String binPropertyName, String url) throws InitializationError {
        this.startProcess(this.buildProcess(locator, binPropertyName, url));
    }

    protected Process startProcess(ProcessBuilder builder) throws InitializationError {
        try {
            Process p = builder.start();
            if (this.config.isDebugEnabled()) {
                System.out.println("Started " + builder.command().get(0));
            }
            return p;
        }
        catch (IOException e) {
            throw new InitializationError((Throwable)e);
        }
    }

    protected ProcessBuilder buildProcess(BrowserLocator locator, String binPropertyName, String url) {
        String executableName = this.config.getProperty(binPropertyName);
        if (executableName == null) {
            executableName = locator.findBrowserLocationOrFail().launcherFilePath();
        }
        return new ProcessBuilder(executableName, url);
    }

    @Override
    public DriverConfiguration getConfig() {
        return this.config;
    }

    protected boolean isRunningOnWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    protected void appendScriptTag(StringBuilder builder, String script) throws IOException {
        String cleanScript = script.replace("classpath://", "/");
        builder.append("<script src='" + cleanScript + "'></script>\n");
    }

    protected void sendResponse(String content, HttpExchange exchange) throws IOException {
        byte[] response;
        try {
            response = content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        exchange.sendResponseHeaders(200, response.length);
        OutputStream output = exchange.getResponseBody();
        output.write(response);
        output.flush();
    }

    public TestResult buildResult(Map<String, String> queryStringParameters, HttpExchange exchange) {
        String userAgent = exchange.getRequestHeaders().getFirst("User-Agent");
        String result = queryStringParameters.get("result");
        String location = queryStringParameters.get("location");
        String isAssert = queryStringParameters.get("isAssert");
        if (this.getConfig().isDebugEnabled()) {
            System.out.println("Result was: " + result + ", at " + location + ", from " + userAgent);
        }
        return new TestResult(userAgent, result, location, "true".equals(isAssert));
    }

    @Override
    public void stop() {
    }

    protected static Set<Class<? extends AsyncProcess>> processSet(Class<? extends AsyncProcess> ... clazz) {
        HashSet<Class<? extends AsyncProcess>> deps = new HashSet<Class<? extends AsyncProcess>>();
        for (Class<? extends AsyncProcess> c : clazz) {
            deps.add(c);
        }
        return deps;
    }
}

