/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.stjs.testing.driver.AsyncProcess;
import org.stjs.testing.driver.DriverConfiguration;

public class Xvfb
implements AsyncProcess {
    private static final int DEFAULT_DISPLAY_NUMBER = 20;
    private static final Pattern DISPLAY_EXP = Pattern.compile("[^:]*:([0-9]*)(\\.([0-9]*))?");
    private String xvfbExecutable = "Xvfb";
    private String display;
    private String[] options = new String[0];
    private File logFile;
    private final DriverConfiguration config;
    private Process xvfbProcess;

    public Xvfb(DriverConfiguration config) {
        this.config = config;
    }

    @Override
    public void start() {
        if (this.config.isDebugEnabled()) {
            System.out.println("Starting Xvfb...");
        }
        if (this.display == null) {
            this.display = this.detectUsableDisplay();
        } else if (this.isDisplayInUse(this.display)) {
            throw new RuntimeException("It appears that the configured display is already in use: " + this.display);
        }
        if (this.config.isDebugEnabled()) {
            System.out.println("Using display: " + this.display);
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.xvfbExecutable);
        command.add(this.display);
        for (String option : this.options) {
            command.add(option);
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(command);
        try {
            this.xvfbProcess = pb.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.logFile != null) {
            // empty if block
        }
    }

    private String detectUsableDisplay() {
        if (this.config.isDebugEnabled()) {
            System.out.println("Detecting a usable display...");
        }
        boolean found = false;
        for (int n = 20; !found && n <= 30; ++n) {
            String d = ":" + n;
            if (this.config.isDebugEnabled()) {
                System.out.println("Trying display: " + n);
            }
            if (this.isDisplayInUse(d)) continue;
            return d;
        }
        throw new RuntimeException("Could not find a usable display");
    }

    private int decodeDisplayPort(String display) {
        assert (display != null);
        Matcher m = DISPLAY_EXP.matcher(display);
        m.matches();
        int i = Integer.parseInt(m.group(1));
        return 6000 + i;
    }

    private boolean isDisplayInUse(String display) {
        int port = this.decodeDisplayPort(display);
        if (this.config.isDebugEnabled()) {
            System.out.println("Checking if display is in use: " + display + " on port: " + port);
        }
        try {
            Socket socket = new Socket("localhost", port);
            socket.close();
            return true;
        }
        catch (ConnectException e) {
            return false;
        }
        catch (UnknownHostException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void stop() {
        this.xvfbProcess.destroy();
    }

    public String getDisplay() {
        return this.display;
    }
}

