/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import java.io.File;
import java.io.IOException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.stjs.javascript.annotation.STJSBridge;
import org.stjs.testing.driver.JUnitSession;
import org.stjs.testing.driver.MultiTestMethod;
import org.stjs.testing.driver.TestResultCollection;
import org.stjs.testing.driver.browser.Browser;

@STJSBridge
public class STJSTestDriverRunner
extends BlockJUnit4ClassRunner {
    public static final File targetDirectory = new File("target", "stjs-test");

    public STJSTestDriverRunner(Class<?> klass) throws InitializationError, IOException {
        super(klass);
        JUnitSession.getInstance().runnerInstantiated(this);
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
        JUnitSession.getInstance().runnerCompleted(this);
    }

    protected Statement methodBlock(final FrameworkMethod method) {
        return new Statement(){

            public void evaluate() throws Throwable {
                JUnitSession session = JUnitSession.getInstance();
                session.testStarting(STJSTestDriverRunner.this, method);
                if (session.getConfig().isDebugEnabled()) {
                    System.out.println("Executing Statement for " + method.getMethod().toString());
                }
                MultiTestMethod aMethod = new MultiTestMethod(STJSTestDriverRunner.this.getTestClass(), method, session.getConfig().getBrowserCount());
                for (Browser browser : session.getBrowsers()) {
                    browser.executeTest(aMethod);
                }
                TestResultCollection results = aMethod.awaitExecutionResult();
                session.testCompleted(STJSTestDriverRunner.this, method, results);
                if (!results.isOk()) {
                    throw results.buildException(session.getConfig().getClassLoader());
                }
            }
        };
    }
}

