/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import java.util.ArrayList;
import java.util.List;
import org.stjs.testing.driver.TestResult;

public class TestResultCollection {
    private final List<TestResult> results = new ArrayList<TestResult>();
    private final String testClassName;
    private final String testMethodName;

    public TestResultCollection(String testClassName, String testMethodName) {
        this.testClassName = testClassName;
        this.testMethodName = testMethodName;
    }

    public synchronized void addResult(TestResult result) {
        this.results.add(result);
        this.notify();
    }

    public synchronized boolean isOk() {
        for (TestResult result : this.results) {
            if (result.isOk()) continue;
            return false;
        }
        return true;
    }

    public synchronized TestResult getResult(int i) {
        return this.results.get(i);
    }

    public synchronized int size() {
        return this.results.size();
    }

    public synchronized AssertionError buildException(String className, String methodName) {
        for (TestResult result : this.results) {
            if (result.isOk()) continue;
            return result.buildException(className, methodName);
        }
        return null;
    }

    public String getTestClassName() {
        return this.testClassName;
    }

    public String getTestMethodName() {
        return this.testMethodName;
    }
}

