/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.stjs.testing.driver.BrowserConnection;
import org.stjs.testing.driver.StreamUtils;
import org.stjs.testing.driver.TestResult;
import org.stjs.testing.driver.TestResultCollection;

public class STJSTestServer {
    protected static final String BROWSER_CHECK_URI = "/check";
    protected static final String BROWSER_RESULT_URI = "/result";
    protected static final String BROWSER_TEST_URI = "/test";
    private final int port;
    private final int testTimeout;
    private final HttpServer httpServer;
    private final Map<Long, BrowserConnection> browserConnections = new HashMap<Long, BrowserConnection>();
    private long lastBrowserId = System.currentTimeMillis();
    private long lastTestId = System.currentTimeMillis();
    private boolean debug;
    private File testFile = null;
    private TestResultCollection results;
    private Set<Long> browserWithCurrentTest;
    private final ClassLoader classLoader;

    public STJSTestServer(ClassLoader classLoader, int port, int testTimeout, boolean debugParam) throws IOException {
        this.port = port;
        this.testTimeout = testTimeout;
        this.debug = debugParam;
        this.classLoader = classLoader;
        InetSocketAddress address = new InetSocketAddress(port);
        this.httpServer = HttpServer.create(address, 0);
        HttpHandler handler = new HttpHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(HttpExchange exchange) throws IOException {
                if (STJSTestServer.this.debug) {
                    System.out.println(exchange.getRequestMethod() + ": " + exchange.getRequestURI());
                }
                try {
                    Map params = STJSTestServer.this.parseQueryString(exchange.getRequestURI().getQuery());
                    exchange.getResponseHeaders().add("Date", STJSTestServer.this.formatDateHeader(new Date()));
                    exchange.getResponseHeaders().add("Last-Modified", STJSTestServer.this.formatDateHeader(new Date()));
                    exchange.getResponseHeaders().add("Connection", "Keep-Alive");
                    exchange.getResponseHeaders().add("Server", "STJS");
                    String path = exchange.getRequestURI().getPath();
                    if ("/".equals(path) || "/start.html".equals(path)) {
                        STJSTestServer.this.handleResource("/start.html", exchange);
                    } else if (STJSTestServer.BROWSER_CHECK_URI.equals(path)) {
                        STJSTestServer.this.handleBrowser(params, exchange);
                    } else if (STJSTestServer.BROWSER_RESULT_URI.equals(path)) {
                        STJSTestServer.this.handleBrowserResult(params, exchange);
                    } else if (STJSTestServer.BROWSER_TEST_URI.equals(path)) {
                        STJSTestServer.this.handleBrowserTest(params, exchange);
                    } else {
                        STJSTestServer.this.handleResource(path, exchange);
                    }
                }
                catch (Exception ex) {
                    System.err.println("Error processing request:" + ex);
                    ex.printStackTrace();
                }
                finally {
                    exchange.close();
                }
            }
        };
        this.httpServer.createContext("/", handler);
    }

    private String formatDateHeader(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ZZZ", Locale.ENGLISH);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(date);
    }

    private void addNoCache(HttpExchange exchange) {
        exchange.getResponseHeaders().add("CacheControl", "no-cache");
        exchange.getResponseHeaders().add("Pragma", "no-cache");
        exchange.getResponseHeaders().add("Expires", "-1");
    }

    private Map<String, String> parseQueryString(String query) {
        String[] nameValues;
        HashMap<String, String> params = new HashMap<String, String>();
        if (query == null) {
            return params;
        }
        for (String nv : nameValues = query.split("&")) {
            String[] x = nv.split("=");
            if (x.length != 2) continue;
            params.put(x[0], x[1]);
        }
        return params;
    }

    private synchronized void handleBrowserResult(Map<String, String> params, HttpExchange exchange) throws IOException {
        this.addNoCache(exchange);
        long id = this.parseLong(params.get("id"), -1L);
        long testId = this.parseLong(params.get("testId"), -1L);
        if (id < 0L || testId < 0L) {
            System.err.println("Test id or browser id missing");
            return;
        }
        BrowserConnection b = this.browserConnections.get(id);
        if (b != null && testId == this.lastTestId && this.results != null) {
            this.results.addResult(b.buildResult(params.get("result"), params.get("location")));
        }
        exchange.sendResponseHeaders(200, 0L);
        OutputStream output = exchange.getResponseBody();
        output.flush();
    }

    private synchronized void handleResource(String path, HttpExchange exchange) throws IOException, URISyntaxException {
        if (path.endsWith(".js")) {
            exchange.getResponseHeaders().add("Content-Type", "text/javascript");
        } else if (path.endsWith(".html")) {
            exchange.getResponseHeaders().add("Content-Type", "text/html; charset=UTF-8");
        }
        String cleanPath = path.replaceFirst("file:/+target", "target");
        if (!StreamUtils.copy(this.classLoader, cleanPath, exchange)) {
            System.err.println(cleanPath + " was not found in classpath");
        }
    }

    private long parseLong(String s, long defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(s);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    private synchronized void handleBrowser(Map<String, String> params, HttpExchange exchange) throws IOException {
        BrowserConnection b;
        this.addNoCache(exchange);
        long id = this.parseLong(params.get("id"), -1L);
        if (id < 0L) {
            id = ++this.lastBrowserId;
        }
        if ((b = this.browserConnections.get(id)) == null) {
            b = new BrowserConnection(id, exchange.getRequestHeaders().getFirst("User-Agent"));
            this.browserConnections.put(id, b);
        }
        StringBuilder jsonResponse = new StringBuilder();
        jsonResponse.append("{");
        jsonResponse.append("id:").append(id);
        if (this.testFile != null && !this.browserWithCurrentTest.contains(id)) {
            jsonResponse.append(",src:").append("'").append(BROWSER_TEST_URI).append("?test=").append(this.lastTestId).append("'");
            jsonResponse.append(",testId:").append(this.lastTestId);
            jsonResponse.append(",className:'").append(this.results.getTestClassName()).append("'");
            jsonResponse.append(",methodName:'").append(this.results.getTestMethodName()).append("'");
            this.browserWithCurrentTest.add(id);
        }
        jsonResponse.append("}");
        byte[] response = jsonResponse.toString().getBytes();
        exchange.sendResponseHeaders(200, response.length);
        OutputStream output = exchange.getResponseBody();
        output.write(response);
        output.flush();
    }

    private synchronized void handleBrowserTest(Map<String, String> params, HttpExchange exchange) throws IOException, URISyntaxException {
        this.addNoCache(exchange);
        if (this.testFile == null) {
            exchange.sendResponseHeaders(404, 0L);
            return;
        }
        if (!StreamUtils.copy(this.classLoader, "/" + this.testFile.getName(), exchange)) {
            System.err.println("/" + this.testFile.getName() + " was not found in classpath");
        }
    }

    public synchronized void start() {
        this.httpServer.start();
    }

    public synchronized void stop() {
        this.httpServer.stop(0);
    }

    public synchronized int getBrowserCount() {
        return this.browserConnections.size();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResultCollection test(File srcFile, String testClassName, String testMethodName) throws InterruptedException {
        int testBrowsers;
        STJSTestServer sTJSTestServer = this;
        synchronized (sTJSTestServer) {
            ++this.lastTestId;
            this.testFile = srcFile;
            this.results = new TestResultCollection(testClassName, testMethodName);
            this.browserWithCurrentTest = new HashSet<Long>();
            testBrowsers = this.browserConnections.size();
        }
        long endTime = System.currentTimeMillis() + (long)(this.testTimeout * 1000);
        TestResultCollection testResultCollection = this.results;
        synchronized (testResultCollection) {
            long stillToWait;
            while (this.results.size() != testBrowsers && (stillToWait = endTime - System.currentTimeMillis()) > 0L) {
                this.results.wait(stillToWait);
            }
        }
        this.testFile = null;
        if (this.results.size() == 0) {
            this.results.addResult(new TestResult("none", "No test responded back in " + this.testTimeout + " seconds", "none"));
        }
        return this.results;
    }

    public URL getHostURL() {
        try {
            return new URL("http", "localhost", this.port, "/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

