/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.LinkedHashSet;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.stjs.generator.ClassWithJavascript;
import org.stjs.generator.DependencyCollection;
import org.stjs.generator.Generator;
import org.stjs.javascript.annotation.STJSBridge;
import org.stjs.testing.annotation.HTMLFixture;
import org.stjs.testing.annotation.Scripts;
import org.stjs.testing.driver.DriverConfiguration;
import org.stjs.testing.driver.ServerSession;
import org.stjs.testing.driver.StreamUtils;
import org.stjs.testing.driver.TestResultCollection;

@STJSBridge
public class STJSTestDriverRunner
extends BlockJUnit4ClassRunner {
    private boolean skipIfNoBrowser = false;
    private final ServerSession serverSession;
    private final DriverConfiguration config;
    public static final File targetDirectory = new File("target", "stjs-test");

    public STJSTestDriverRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.config = new DriverConfiguration(klass);
        this.skipIfNoBrowser = this.config.isSkipIfNoBrowser();
        try {
            this.serverSession = ServerSession.getInstance(this.config);
        }
        catch (Exception e) {
            throw new InitializationError((Throwable)e);
        }
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (!this.serverSession.hasBrowsers()) {
            if (this.skipIfNoBrowser) {
                EachTestNotifier eachNotifier = this.makeNotifier(method, notifier);
                eachNotifier.fireTestIgnored();
            } else {
                notifier.fireTestFailure(new Failure(this.describeChild(method), (Throwable)new IllegalStateException("No connected browser")));
            }
            return;
        }
        super.runChild(method, notifier);
    }

    private EachTestNotifier makeNotifier(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        return new EachTestNotifier(notifier, description);
    }

    private void addScript(Writer writer, String script) throws IOException {
        String cleanScript = script.replace("classpath://", "/");
        writer.append("<script src='" + cleanScript + "'></script>\n");
    }

    protected Statement methodBlock(final FrameworkMethod method) {
        return new Statement(){

            public void evaluate() throws Throwable {
                FileWriter writer;
                File htmlFile;
                block16: {
                    ClassWithJavascript stjsClass = new Generator().getExistingStjsClass(STJSTestDriverRunner.this.config.getClassLoader(), STJSTestDriverRunner.this.getTestClass().getJavaClass());
                    HTMLFixture htmlFixture = STJSTestDriverRunner.this.getTestClass().getJavaClass().getAnnotation(HTMLFixture.class);
                    Scripts addedScripts = STJSTestDriverRunner.this.getTestClass().getJavaClass().getAnnotation(Scripts.class);
                    htmlFile = null;
                    writer = null;
                    try {
                        TestResultCollection response;
                        targetDirectory.mkdirs();
                        htmlFile = new File(targetDirectory, STJSTestDriverRunner.this.getTestClass().getJavaClass().getName() + "-" + method.getName() + ".html");
                        writer = new FileWriter(htmlFile);
                        writer.append("<html>");
                        writer.append("<head>");
                        STJSTestDriverRunner.this.addScript(writer, "/stjs.js");
                        STJSTestDriverRunner.this.addScript(writer, "/junit.js");
                        writer.append("<script language='javascript'>stjs.mainCallDisabled=true;</script>");
                        if (addedScripts != null) {
                            for (String script : addedScripts.value()) {
                                STJSTestDriverRunner.this.addScript(writer, script);
                            }
                        }
                        LinkedHashSet<URI> jsFiles = new LinkedHashSet<URI>();
                        for (ClassWithJavascript dep : new DependencyCollection(stjsClass).orderAllDependencies(STJSTestDriverRunner.this.config.getClassLoader())) {
                            for (URI file : dep.getJavascriptFiles()) {
                                jsFiles.add(file);
                            }
                        }
                        for (URI file : jsFiles) {
                            STJSTestDriverRunner.this.addScript(writer, file.toString());
                        }
                        writer.append("<script language='javascript'>");
                        writer.append("onload=function(){");
                        writer.append("Assert=window;");
                        String testedClassName = STJSTestDriverRunner.this.getTestClass().getJavaClass().getSimpleName();
                        writer.append("try{");
                        writer.append("new " + testedClassName + "()." + method.getName() + "();");
                        writer.append("parent.sendOK('" + testedClassName + "." + method.getName() + "');");
                        writer.append("}catch(ex){");
                        writer.append("parent.sendError('" + testedClassName + "." + method.getName() + "', ex);");
                        writer.append("}");
                        writer.append("}");
                        writer.append("</script>");
                        writer.append("</head>");
                        writer.append("<body>");
                        if (htmlFixture != null) {
                            if (!Strings.isNullOrEmpty((String)htmlFixture.value())) {
                                writer.append(htmlFixture.value());
                            } else if (!Strings.isNullOrEmpty((String)htmlFixture.url())) {
                                StreamUtils.copy(STJSTestDriverRunner.this.serverSession.getServer().getClassLoader(), htmlFixture.url(), writer);
                            }
                        }
                        writer.append("</body>");
                        writer.append("</html>");
                        writer.flush();
                        writer.close();
                        if (STJSTestDriverRunner.this.config.isDebugEnabled()) {
                            System.out.println("Added source file");
                            Files.copy((File)htmlFile, (OutputStream)System.out);
                            System.out.flush();
                        }
                        if ((response = STJSTestDriverRunner.this.serverSession.getServer().test(htmlFile, testedClassName, method.getName())).isOk()) break block16;
                        throw response.buildException(STJSTestDriverRunner.this.getTestClass().getJavaClass().getName(), method.getName());
                    }
                    catch (IOException e) {
                        try {
                            throw new RuntimeException(e);
                        }
                        catch (Throwable throwable) {
                            Closeables.closeQuietly(writer);
                            if (htmlFile != null) {
                                htmlFile.delete();
                            }
                            throw throwable;
                        }
                    }
                }
                Closeables.closeQuietly((Closeable)writer);
                if (htmlFile != null) {
                    htmlFile.delete();
                }
            }
        };
    }
}

