/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.stjs.testing.driver.WebAppClassLoader;

public class DriverConfiguration {
    private static final String FILE_NAME = "/stjs-test.properties";
    private static final String PROP_PORT = "stjs.test.port";
    private static final String PROP_WAIT_FOR_BROWSER = "stjs.test.wait";
    private static final String PROP_SKIP_IF_NO_BROWSER = "stjs.test.skipIfNoBrowser";
    private static final String PROP_START_BROWSER = "stjs.test.startBrowser";
    private static final String PROP_BROWSER_COUNT = "stjs.test.browserCount";
    private static final String PROP_TEST_TIMEOUT = "stjs.test.testTimeout";
    private static final String PROP_DEBUG = "stjs.test.debug";
    private int port = 8055;
    private int waitForBrowser = 10;
    private boolean skipIfNoBrowser = false;
    private boolean startBrowser = true;
    private int testTimeout = 2;
    private int browserCount = 1;
    private boolean debugEnabled = false;
    private final ClassLoader classLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DriverConfiguration(Class<?> klass) {
        InputStream in = null;
        try {
            in = klass.getResourceAsStream(FILE_NAME);
            if (in != null) {
                Properties props = new Properties();
                props.load(in);
                props.putAll((Map<?, ?>)System.getProperties());
                if (props.get(PROP_PORT) != null) {
                    this.port = Integer.parseInt(props.getProperty(PROP_PORT));
                }
                if (props.get(PROP_WAIT_FOR_BROWSER) != null) {
                    this.waitForBrowser = Integer.parseInt(props.getProperty(PROP_WAIT_FOR_BROWSER));
                }
                if (props.get(PROP_SKIP_IF_NO_BROWSER) != null) {
                    this.skipIfNoBrowser = Boolean.parseBoolean(props.getProperty(PROP_SKIP_IF_NO_BROWSER));
                }
                if (props.get(PROP_START_BROWSER) != null) {
                    this.startBrowser = Boolean.parseBoolean(props.getProperty(PROP_START_BROWSER));
                }
                if (props.get(PROP_TEST_TIMEOUT) != null) {
                    this.testTimeout = Integer.parseInt(props.getProperty(PROP_TEST_TIMEOUT));
                }
                if (props.get(PROP_BROWSER_COUNT) != null) {
                    this.browserCount = Integer.parseInt(props.getProperty(PROP_BROWSER_COUNT));
                }
                if (props.get(PROP_DEBUG) != null) {
                    this.debugEnabled = Boolean.parseBoolean(props.getProperty(PROP_DEBUG));
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            Closeables.closeQuietly((Closeable)in);
        }
        this.classLoader = new WebAppClassLoader(new URL[0], klass.getClassLoader(), this.debugEnabled);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getWaitForBrowser() {
        return this.waitForBrowser;
    }

    public void setWaitForBrowser(int waitForBrowser) {
        this.waitForBrowser = waitForBrowser;
    }

    public boolean isSkipIfNoBrowser() {
        return this.skipIfNoBrowser;
    }

    public void setSkipIfNoBrowser(boolean skipIfNoBrowser) {
        this.skipIfNoBrowser = skipIfNoBrowser;
    }

    public boolean isStartBrowser() {
        return this.startBrowser;
    }

    public void setStartBrowser(boolean startBrowser) {
        this.startBrowser = startBrowser;
    }

    public int getTestTimeout() {
        return this.testTimeout;
    }

    public void setTestTimeout(int testTimeout) {
        this.testTimeout = testTimeout;
    }

    public int getBrowserCount() {
        return this.browserCount;
    }

    public void setBrowserCount(int browserCount) {
        this.browserCount = browserCount;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

