/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

public class TestResult {
    private final String message;
    private final int line;
    private final String file;
    private final String userAgent;

    public TestResult(String userAgent, String message, String location) {
        this.userAgent = userAgent;
        this.message = message;
        if (location != null && !location.isEmpty()) {
            String[] locData = location.split(":");
            if (locData.length == 2) {
                this.file = locData[0];
                this.line = Integer.parseInt(locData[1]);
            } else {
                this.file = "none";
                this.line = -1;
            }
        } else {
            this.file = "none";
            this.line = -1;
        }
    }

    public String getMessage() {
        return this.message;
    }

    public int getLine() {
        return this.line;
    }

    public String getFile() {
        return this.file;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isOk() {
        return "OK".equals(this.message);
    }

    public AssertionError buildException(String className, String methodName) {
        AssertionError ex = new AssertionError((Object)(this.message + ", user agent: " + this.userAgent));
        if (this.line >= 0) {
            StackTraceElement[] stackTrace = new StackTraceElement[]{new StackTraceElement(className, methodName, this.file, this.line)};
            ((Throwable)((Object)ex)).setStackTrace(stackTrace);
        }
        return ex;
    }

    public String toString() {
        return "TestResult [message=" + this.message + ", line=" + this.line + ", file=" + this.file + ", userAgent=" + this.userAgent + "]";
    }
}

