/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import java.awt.Desktop;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.stjs.testing.driver.DriverConfiguration;
import org.stjs.testing.driver.STJSTestServer;

public class ServerSession {
    private static ServerSession instance;
    private final STJSTestServer server;
    private int timeout;
    private final boolean hasBrowsers;
    private final int browserCount;
    private final boolean startBrowser;

    public static synchronized ServerSession getInstance(DriverConfiguration config) throws IOException, InterruptedException {
        if (instance == null) {
            instance = new ServerSession(config);
        }
        return instance;
    }

    private ServerSession(DriverConfiguration config) throws IOException, InterruptedException {
        this.timeout = config.getWaitForBrowser() * 1000;
        this.startBrowser = config.isStartBrowser();
        this.browserCount = config.getBrowserCount();
        this.server = new STJSTestServer(config.getPort(), config.getTestTimeout(), config.isDebugEnabled());
        this.server.start();
        this.hasBrowsers = this.checkBrowsers();
    }

    private boolean checkBrowsers() throws InterruptedException, IOException {
        int initialTimeout = 2000;
        int stepTimeout = 500;
        System.out.println("Waiting for " + this.browserCount + " browser(s)");
        try {
            Thread.sleep(Math.min(2000, this.timeout));
            if (this.server.getBrowserCount() < this.browserCount) {
                if (this.startBrowser && Desktop.isDesktopSupported() && this.server.getBrowserCount() == 0) {
                    System.out.println("Starting the default browser ...");
                    Desktop.getDesktop().browse(new URL(this.server.getHostURL(), "/start.html").toURI());
                }
                for (int i = 2000; i < this.timeout; i += 500) {
                    Thread.sleep(500L);
                    if (this.server.getBrowserCount() < this.browserCount) continue;
                    System.out.println("Captured browsers");
                    return true;
                }
                System.err.println("Unable to capture at least " + this.browserCount + " browser(s)");
                return false;
            }
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        System.out.println("Have " + this.server.getBrowserCount() + " browsers connected");
        return true;
    }

    public STJSTestServer getServer() {
        return this.server;
    }

    public boolean hasBrowsers() {
        return this.hasBrowsers;
    }
}

