/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.LinkedHashSet;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.stjs.generator.ClassWithJavascript;
import org.stjs.generator.DependencyCollection;
import org.stjs.generator.Generator;
import org.stjs.javascript.annotation.STJSBridge;
import org.stjs.testing.annotation.HTMLFixture;
import org.stjs.testing.annotation.Scripts;
import org.stjs.testing.driver.DriverConfiguration;
import org.stjs.testing.driver.ServerSession;
import org.stjs.testing.driver.TestResultCollection;

@STJSBridge
public class STJSTestDriverRunner
extends BlockJUnit4ClassRunner {
    private boolean skipIfNoBrowser = false;
    private final ServerSession serverSession;
    private final DriverConfiguration config;

    public STJSTestDriverRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.config = new DriverConfiguration(klass);
        this.skipIfNoBrowser = this.config.isSkipIfNoBrowser();
        try {
            this.serverSession = ServerSession.getInstance(this.config);
        }
        catch (Exception e) {
            throw new InitializationError((Throwable)e);
        }
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (!this.serverSession.hasBrowsers()) {
            if (this.skipIfNoBrowser) {
                EachTestNotifier eachNotifier = this.makeNotifier(method, notifier);
                eachNotifier.fireTestIgnored();
            } else {
                notifier.fireTestFailure(new Failure(this.describeChild(method), (Throwable)new IllegalStateException("No connected browser")));
            }
            return;
        }
        super.runChild(method, notifier);
    }

    private EachTestNotifier makeNotifier(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        return new EachTestNotifier(notifier, description);
    }

    private void addScript(Writer writer, String script) throws IOException {
        if (script.startsWith("classpath:")) {
            writer.append("<script src='" + script.substring("classpath:/".length()) + "'></script>\n");
        } else if (script.startsWith("file:")) {
            writer.append("<script src='/js?" + URLEncoder.encode(script, Charset.defaultCharset().name()) + "'></script>\n");
        } else {
            writer.append("<script src='" + script + "'></script>\n");
        }
    }

    protected Statement methodBlock(final FrameworkMethod method) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ClassWithJavascript stjsClass = new Generator().getExistingStjsClass(STJSTestDriverRunner.this.getTestClass().getJavaClass());
                HTMLFixture htmlFixture = STJSTestDriverRunner.this.getTestClass().getJavaClass().getAnnotation(HTMLFixture.class);
                Scripts addedScripts = STJSTestDriverRunner.this.getTestClass().getJavaClass().getAnnotation(Scripts.class);
                File htmlFile = null;
                try {
                    TestResultCollection response;
                    htmlFile = File.createTempFile(STJSTestDriverRunner.this.getTestClass().getJavaClass().getName() + "_js_test_driver_adapter", ".html");
                    FileWriter writer = new FileWriter(htmlFile);
                    writer.append("<html>");
                    writer.append("<head>");
                    writer.append("<script src='/stjs.js'></script>\n");
                    writer.append("<script src='/junit.js'></script>\n");
                    writer.append("<script language='javascript'>stjs.mainCallDisabled=true;</script>");
                    if (addedScripts != null) {
                        for (String script : addedScripts.value()) {
                            STJSTestDriverRunner.this.addScript(writer, script);
                        }
                    }
                    LinkedHashSet<URI> jsFiles = new LinkedHashSet<URI>();
                    for (ClassWithJavascript dep : new DependencyCollection(stjsClass).orderAllDependencies()) {
                        for (URI file : dep.getJavascriptFiles()) {
                            jsFiles.add(file);
                        }
                    }
                    for (URI file : jsFiles) {
                        STJSTestDriverRunner.this.addScript(writer, file.toString());
                    }
                    writer.append("<script language='javascript'>");
                    writer.append("onload=function(){");
                    writer.append("Assert=window;");
                    String testedClassName = STJSTestDriverRunner.this.getTestClass().getJavaClass().getSimpleName();
                    writer.append("try{");
                    writer.append("new " + testedClassName + "()." + method.getName() + "();");
                    writer.append("parent.sendOK('" + testedClassName + "." + method.getName() + "');");
                    writer.append("}catch(ex){");
                    writer.append("parent.sendError('" + testedClassName + "." + method.getName() + "', ex);");
                    writer.append("}");
                    writer.append("}");
                    writer.append("</script>");
                    writer.append("</head>");
                    writer.append("<body>");
                    if (htmlFixture != null) {
                        writer.append(htmlFixture.value());
                    }
                    writer.append("</body>");
                    writer.append("</html>");
                    writer.flush();
                    writer.close();
                    if (STJSTestDriverRunner.this.config.isDebugEnabled()) {
                        System.out.println("Added source file");
                        Files.copy((File)htmlFile, (OutputStream)System.out);
                        System.out.flush();
                    }
                    if (!(response = STJSTestDriverRunner.this.serverSession.getServer().test(htmlFile)).isOk()) {
                        throw response.buildException(STJSTestDriverRunner.this.getTestClass().getJavaClass().getName(), method.getName());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (htmlFile != null) {
                        htmlFile.delete();
                    }
                }
            }
        };
    }
}

