/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.testing.driver;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.stjs.testing.driver.BrowserConnection;
import org.stjs.testing.driver.TestResult;
import org.stjs.testing.driver.TestResultCollection;

public class STJSTestServer {
    protected static final String BROWSER_CHECK_URI = "/check";
    protected static final String BROWSER_RESULT_URI = "/result";
    protected static final String BROWSER_TEST_URI = "/test";
    protected static final String BROWSER_GET_JS_URI = "/js";
    private final int port;
    private final int testTimeout;
    private final HttpServer httpServer;
    private final Map<Long, BrowserConnection> browserConnections = new HashMap<Long, BrowserConnection>();
    private long lastBrowserId = System.currentTimeMillis();
    private long lastTestId = System.currentTimeMillis();
    private File testFile = null;

    public STJSTestServer(int port, int testTimeout) throws IOException {
        this.port = port;
        this.testTimeout = testTimeout;
        InetSocketAddress address = new InetSocketAddress(port);
        this.httpServer = HttpServer.create(address, 0);
        HttpHandler handler = new HttpHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(HttpExchange exchange) throws IOException {
                System.out.println("GET:" + exchange.getRequestURI());
                try {
                    exchange.getResponseHeaders().add("CacheControl", "no-cache");
                    exchange.getResponseHeaders().add("Pragma", "no-cache");
                    exchange.getResponseHeaders().add("Expires", "-1");
                    Map params = STJSTestServer.this.parseQueryString(exchange.getRequestURI().getQuery());
                    if (STJSTestServer.BROWSER_CHECK_URI.equals(exchange.getRequestURI().getPath())) {
                        STJSTestServer.this.handleBrowser(params, exchange);
                    } else if (STJSTestServer.BROWSER_RESULT_URI.equals(exchange.getRequestURI().getPath())) {
                        STJSTestServer.this.handleBrowserResult(params, exchange);
                    } else if (STJSTestServer.BROWSER_TEST_URI.equals(exchange.getRequestURI().getPath())) {
                        STJSTestServer.this.handleBrowserTest(params, exchange);
                    } else if (STJSTestServer.BROWSER_GET_JS_URI.equals(exchange.getRequestURI().getPath())) {
                        STJSTestServer.this.handleBrowserGetJs(exchange.getRequestURI().getQuery(), exchange);
                    } else {
                        STJSTestServer.this.handleResource(exchange.getRequestURI().getPath().substring(1), exchange);
                    }
                }
                catch (Exception ex) {
                    System.err.println("Error processing request:" + ex);
                    ex.printStackTrace();
                }
                finally {
                    exchange.close();
                }
            }
        };
        this.httpServer.createContext("/", handler);
    }

    private Map<String, String> parseQueryString(String query) {
        String[] nameValues;
        HashMap<String, String> params = new HashMap<String, String>();
        if (query == null) {
            return params;
        }
        for (String nv : nameValues = query.split("&")) {
            String[] x = nv.split("=");
            if (x.length != 2) continue;
            params.put(x[0], x[1]);
        }
        return params;
    }

    private synchronized void handleBrowserResult(Map<String, String> params, HttpExchange exchange) {
        long id = this.parseLong(params.get("id"), -1L);
        long testId = this.parseLong(params.get("testId"), -1L);
        if (id < 0L || testId < 0L) {
            System.out.println("Test id or browser id missing");
            return;
        }
        BrowserConnection b = this.browserConnections.get(id);
        if (b != null && testId == this.lastTestId) {
            b.setResult(new TestResult(params.get("result"), params.get("location")));
            b.setLastTestId(testId);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleResource(String path, HttpExchange exchange) throws IOException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        try {
            if (is != null) {
                if (path.endsWith(".js")) {
                    exchange.getResponseHeaders().add("Content-type", "text/javascript");
                }
                exchange.sendResponseHeaders(200, 0L);
                ByteStreams.copy((InputStream)is, (OutputStream)exchange.getResponseBody());
            } else {
                System.err.println(path + " was not found in classpath");
                exchange.sendResponseHeaders(404, 0L);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private long parseLong(String s, long defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(s);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    private synchronized void handleBrowser(Map<String, String> params, HttpExchange exchange) throws IOException {
        BrowserConnection b;
        exchange.sendResponseHeaders(200, 0L);
        long id = this.parseLong(params.get("id"), -1L);
        if (id < 0L) {
            id = ++this.lastBrowserId;
        }
        if ((b = this.browserConnections.get(id)) == null) {
            b = new BrowserConnection();
            this.browserConnections.put(id, b);
        }
        StringBuilder jsonResponse = new StringBuilder();
        jsonResponse.append("{");
        jsonResponse.append("id:").append(id);
        if (this.testFile != null && b.getLastTestId() != this.lastTestId) {
            jsonResponse.append(",src:").append("'").append(BROWSER_TEST_URI).append("?test=").append(this.lastTestId).append("'");
            jsonResponse.append(",testId:").append(this.lastTestId);
        }
        jsonResponse.append("}");
        exchange.getResponseBody().write(jsonResponse.toString().getBytes());
    }

    private synchronized void handleBrowserTest(Map<String, String> params, HttpExchange exchange) throws IOException {
        if (this.testFile == null || !this.testFile.exists()) {
            exchange.sendResponseHeaders(404, 0L);
            return;
        }
        exchange.sendResponseHeaders(200, 0L);
        Files.copy((File)this.testFile, (OutputStream)exchange.getResponseBody());
    }

    private synchronized void handleBrowserGetJs(String fileName, HttpExchange exchange) throws IOException, URISyntaxException {
        exchange.getResponseHeaders().add("Content-type", "text/javascript");
        URI uri = new URI(fileName);
        if ("classpath".equals(uri.getScheme())) {
            this.handleResource(uri.getPath(), exchange);
        } else {
            exchange.sendResponseHeaders(200, 0L);
            Files.copy((File)new File(uri.getPath().substring(1)), (OutputStream)exchange.getResponseBody());
        }
    }

    public synchronized void start() {
        this.httpServer.start();
    }

    public synchronized void stop() {
        this.httpServer.stop(0);
    }

    public synchronized int getBrowserCount() {
        return this.browserConnections.size();
    }

    public synchronized TestResultCollection test(File srcFile) throws InterruptedException {
        ++this.lastTestId;
        this.testFile = srcFile;
        System.out.println("--> testing :" + this.lastTestId + ", file:" + this.testFile);
        int testBrowsers = 0;
        long endTime = System.currentTimeMillis() + (long)(this.testTimeout * 1000);
        TestResultCollection result = new TestResultCollection();
        while (true) {
            for (BrowserConnection b : this.browserConnections.values()) {
                if (b.getLastTestId() != this.lastTestId) continue;
                System.out.println("FOUND result:" + b);
                result.addResult(b.getResult());
                ++testBrowsers;
            }
            if (testBrowsers == this.browserConnections.size() || System.currentTimeMillis() >= endTime) break;
            this.wait(500L);
        }
        System.out.println("<-- testing :" + this.lastTestId + ", file:" + this.testFile);
        this.testFile = null;
        if (result.size() == 0) {
            result.addResult(new TestResult("No test responded back in " + this.testTimeout + " seconds", "none"));
        }
        return result;
    }

    public URL getHostURL() {
        try {
            return new URL("http", "localhost", this.port, "/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

