/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.javascript;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.text.DecimalFormat;
import org.stjs.javascript.Date;

class JSAbstractOperations {
    private static final DecimalFormat PLAIN_INTEGER_FORMAT = new DecimalFormat("#0");
    private static final BigInteger UINT_MAX_VALUE = new BigInteger("4294967296");
    private static final BigInteger SINT_MAX_VALUE = new BigInteger("2147483648");
    private static final BigInteger USHORT_MAX_VALUE = new BigInteger("65536");

    JSAbstractOperations() {
    }

    static Object DefaultValue(Object arg) {
        return JSAbstractOperations.DefaultValue(arg, null);
    }

    static Object DefaultValue(Object arg, String hint) {
        if (hint == null) {
            if (arg instanceof Date) {
                return JSAbstractOperations.DefaultValue(arg, "String");
            }
            return JSAbstractOperations.DefaultValue(arg, "Number");
        }
        if (hint.equals("String")) {
            try {
                return JSAbstractOperations.callToString(arg);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException().getMessage(), e.getTargetException());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (hint.equals("Number")) {
            if (JSAbstractOperations.isValueOfCallable(arg)) {
                try {
                    Object value = JSAbstractOperations.callValueOf(arg);
                    if (JSAbstractOperations.isJsPrimitiveEquivalent(value)) {
                        return value;
                    }
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getTargetException().getMessage(), e.getTargetException());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                return JSAbstractOperations.callToString(arg);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException().getMessage(), e.getTargetException());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("Unknown hint: " + hint);
    }

    private static String callToString(Object target) throws Exception {
        Method toString = target.getClass().getMethod("toString", new Class[0]);
        if (toString.getDeclaringClass().equals(Object.class)) {
            return (String)toString.invoke(target, new Object[0]);
        }
        return (String)toString.invoke(target, new Object[0]);
    }

    private static boolean isValueOfCallable(Object target) {
        try {
            return target.getClass().getMethod("valueOf", new Class[0]) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Object callValueOf(Object target) throws Exception {
        Method valueOf = target.getClass().getMethod("valueOf", new Class[0]);
        return valueOf.invoke(target, new Object[0]);
    }

    private static boolean isJsPrimitiveEquivalent(Object arg) {
        return arg == null || arg instanceof Boolean || arg instanceof String || arg instanceof Number;
    }

    static Object ToPrimitive(Object arg) {
        return JSAbstractOperations.ToPrimitive(arg, "Number");
    }

    static Object ToPrimitive(Object arg, String hint) {
        if (arg == null || arg instanceof Boolean || arg instanceof Number || arg instanceof String) {
            return arg;
        }
        return JSAbstractOperations.DefaultValue(arg, hint);
    }

    static Boolean ToBoolean(Object arg) {
        if (arg == null) {
            return Boolean.FALSE;
        }
        if (arg instanceof Boolean) {
            return (Boolean)arg;
        }
        if (arg instanceof Number) {
            double value = ((Number)arg).doubleValue();
            return !Double.isNaN(value) && value != 0.0;
        }
        if (arg instanceof String) {
            return !"".equals(arg);
        }
        return true;
    }

    static Double ToNumber(Object arg) {
        if (arg == null) {
            return 0.0;
        }
        if (Boolean.TRUE.equals(arg)) {
            return 1.0;
        }
        if (Boolean.FALSE.equals(arg)) {
            return 0.0;
        }
        if (arg instanceof String) {
            return JSAbstractOperations.ToNumber((String)arg);
        }
        if (arg instanceof Number) {
            return ((Number)arg).doubleValue();
        }
        Object primValue = JSAbstractOperations.ToPrimitive(arg, "Number");
        return (double)JSAbstractOperations.ToNumber(primValue);
    }

    static Double ToNumber(String arg) {
        if (arg == null) {
            return 0.0;
        }
        String trimmed = arg.trim();
        if (trimmed.isEmpty()) {
            return 0.0;
        }
        if ("Infinity".equals(arg)) {
            return Double.POSITIVE_INFINITY;
        }
        if (trimmed.startsWith("0x") || trimmed.startsWith("0X")) {
            try {
                return Long.decode(trimmed).doubleValue();
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }
        try {
            return Double.parseDouble(trimmed);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    static Double ToInteger(Object arg) {
        Double number = JSAbstractOperations.ToNumber(arg);
        if (number.isNaN()) {
            return 0.0;
        }
        if (number.isInfinite()) {
            return number;
        }
        return Math.signum(number) * Math.floor(Math.abs(number));
    }

    static Double ToInt32(Object arg) {
        Double number = JSAbstractOperations.ToNumber(arg);
        if (number.isNaN() || number.isInfinite() || number == 0.0) {
            return 0.0;
        }
        Double posInt = JSAbstractOperations.ToInteger(number);
        BigInteger posIntBig = new BigInteger(PLAIN_INTEGER_FORMAT.format(posInt));
        BigInteger int32bit = posIntBig.mod(UINT_MAX_VALUE);
        if (int32bit.compareTo(SINT_MAX_VALUE) >= 0) {
            return int32bit.subtract(UINT_MAX_VALUE).doubleValue();
        }
        return int32bit.doubleValue();
    }

    static Double ToUInt32(Object arg) {
        Double number = JSAbstractOperations.ToNumber(arg);
        if (number.isNaN() || number.isInfinite() || number == 0.0) {
            return 0.0;
        }
        Double posInt = JSAbstractOperations.ToInteger(number);
        BigInteger posIntBig = new BigInteger(PLAIN_INTEGER_FORMAT.format(posInt));
        BigInteger int32bit = posIntBig.mod(UINT_MAX_VALUE);
        return int32bit.doubleValue();
    }

    static Double ToUInt16(Object arg) {
        Double number = JSAbstractOperations.ToNumber(arg);
        if (number.isNaN() || number.isInfinite() || number == 0.0) {
            return 0.0;
        }
        Double posInt = JSAbstractOperations.ToInteger(number);
        BigInteger posIntBig = new BigInteger(PLAIN_INTEGER_FORMAT.format(posInt));
        BigInteger int16bit = posIntBig.mod(USHORT_MAX_VALUE);
        return int16bit.doubleValue();
    }

    static String ToString(Object arg) {
        if (arg == null) {
            return "null";
        }
        if (Boolean.TRUE.equals(arg)) {
            return "true";
        }
        if (Boolean.FALSE.equals(arg)) {
            return "false";
        }
        if (arg instanceof String) {
            return (String)arg;
        }
        if (arg instanceof Number) {
            return JSAbstractOperations.ToString((Number)arg);
        }
        Object primValue = JSAbstractOperations.ToPrimitive(arg, "String");
        return JSAbstractOperations.ToString(primValue);
    }

    static String ToString(Number arg) {
        if (arg == null) {
            return "null";
        }
        return arg.toString();
    }

    static Object ToObject(Object arg) {
        if (arg == null) {
            throw new RuntimeException("TypeError");
        }
        return arg;
    }

    static boolean CheckObjectCoercible(Object arg) {
        return arg != null;
    }
}

