/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.javascript;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class Date {
    private Calendar calendar;
    private Calendar utc;
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public Date() {
        this.calendar = Calendar.getInstance();
    }

    public Date(long milliseconds) {
        this.getUTC(true).setTimeInMillis(milliseconds);
    }

    public Date(String dateString) {
        java.util.Date d = null;
        try {
            d = new SimpleDateFormat(DEFAULT_DATE_PATTERN).parse(dateString);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (d != null) {
            this.calendar = Calendar.getInstance();
            this.calendar.setTime(d);
        } else {
            this.calendar = null;
        }
    }

    public Date(int year, int month, int day, int hours, int minutes, int seconds, int ms) {
        this.calendar = new GregorianCalendar(year, month, day, hours, minutes, seconds);
        this.calendar.set(14, ms);
    }

    private Calendar getUTC(boolean forceCreate) {
        if (this.utc == null) {
            if (this.calendar != null) {
                this.utc = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                this.utc.setTimeInMillis(this.calendar.getTimeInMillis());
            } else if (forceCreate) {
                this.utc = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            }
        }
        return this.utc;
    }

    private Calendar getCalendar(boolean forceCreate) {
        if (this.calendar == null) {
            if (this.utc != null) {
                this.calendar = Calendar.getInstance();
                this.calendar.setTimeInMillis(this.utc.getTimeInMillis());
            } else if (forceCreate) {
                this.calendar = Calendar.getInstance();
            }
        }
        return this.calendar;
    }

    private double getField(Calendar c, int field) {
        if (c == null) {
            return Double.NaN;
        }
        return c.get(field);
    }

    private void setField(Calendar c, int field, int n) {
        if (c == null) {
            throw new IllegalStateException("The calendar shold not be null");
        }
        c.set(field, n);
        if (c == this.calendar) {
            this.utc = null;
        } else {
            this.calendar = null;
        }
    }

    public double getDate() {
        return this.getField(this.getCalendar(false), 5);
    }

    public double getDay() {
        return this.getField(this.getCalendar(false), 7);
    }

    public double getFullYear() {
        return this.getField(this.getCalendar(false), 1);
    }

    public double getHours() {
        return this.getField(this.getCalendar(false), 11);
    }

    public double getMilliseconds() {
        return this.getField(this.getCalendar(false), 14);
    }

    public double getMinutes() {
        return this.getField(this.getCalendar(false), 12);
    }

    public double getMonth() {
        return this.getField(this.getCalendar(false), 2);
    }

    public double getSeconds() {
        return this.getField(this.getCalendar(false), 13);
    }

    public double getTime() {
        if (this.getCalendar(false) != null) {
            return this.calendar.getTimeInMillis();
        }
        return Double.NaN;
    }

    public double getTimezoneOffset() {
        if (this.getCalendar(false) != null) {
            return -this.calendar.getTimeZone().getRawOffset() / 1000 / 60;
        }
        return Double.NaN;
    }

    public double getUTCDate() {
        return this.getField(this.getUTC(false), 5);
    }

    public double getUTCDay() {
        return this.getField(this.getUTC(false), 7);
    }

    public double getUTCFullYear() {
        return this.getField(this.getUTC(false), 1);
    }

    public double getUTCHours() {
        return this.getUTC(false).get(11);
    }

    public double getUTCMilliseconds() {
        return this.getField(this.getUTC(false), 14);
    }

    public double getUTCMinutes() {
        return this.getField(this.getUTC(false), 12);
    }

    public double getUTCMonth() {
        return this.getField(this.getUTC(false), 2);
    }

    public double getUTCSeconds() {
        return this.getField(this.getUTC(false), 13);
    }

    public double getYear() {
        return this.getFullYear() - 1900.0;
    }

    public static double parse(String date) {
        return new Date(date).getTime();
    }

    public void setDate(int n) {
        this.setField(this.getCalendar(true), 7, n);
    }

    public void setFullYear(int n) {
        this.setField(this.getCalendar(true), 1, n);
    }

    public void setHours(int n) {
        this.setField(this.getCalendar(true), 11, n);
    }

    public void setMilliseconds(int n) {
        this.setField(this.getCalendar(true), 14, n);
    }

    public void setMinutes(int n) {
        this.setField(this.getCalendar(true), 12, n);
    }

    public void setMonth(int n) {
        this.setField(this.getCalendar(true), 2, n);
    }

    public void setSeconds(int n) {
        this.setField(this.getCalendar(true), 13, n);
    }

    public void setTime(int n) {
        this.getCalendar(true).setTimeInMillis(n);
    }

    public void setUTCDate(int n) {
        this.setField(this.getUTC(true), 5, n);
    }

    public void setUTCFullYear(int n) {
        this.setField(this.getUTC(true), 1, n);
    }

    public void setUTCHours(int n) {
        this.setField(this.getUTC(true), 11, n);
    }

    public void setUTCMilliseconds(int n) {
        this.setField(this.getUTC(true), 14, n);
    }

    public void setUTCMinutes(int n) {
        this.setField(this.getUTC(true), 12, n);
    }

    public void setUTCMonth(int n) {
        this.setField(this.getUTC(true), 2, n);
    }

    public void setUTCSeconds(int n) {
        this.setField(this.getUTC(true), 13, n);
    }

    public void setYear(int n) {
        this.setField(this.getUTC(true), 1, n);
    }

    public String toDateString() {
        if (this.getCalendar(false) != null) {
            return DateFormat.getDateInstance(0, Locale.US).format(this.calendar.getTime());
        }
        return null;
    }

    public String toGMTString() {
        return this.toUTCString();
    }

    public String toLocaleDateString() {
        if (this.getCalendar(false) != null) {
            return DateFormat.getDateInstance(0, Locale.getDefault()).format(this.calendar.getTime());
        }
        return null;
    }

    public String toLocaleTimeString() {
        if (this.getCalendar(false) != null) {
            return DateFormat.getTimeInstance(0, Locale.getDefault()).format(this.calendar.getTime());
        }
        return null;
    }

    public String toLocaleString() {
        if (this.getCalendar(false) != null) {
            return DateFormat.getDateTimeInstance(0, 0, Locale.getDefault()).format(this.calendar.getTime());
        }
        return null;
    }

    public String toString() {
        if (this.getCalendar(false) != null) {
            return DateFormat.getDateTimeInstance(0, 0, Locale.US).format(this.calendar.getTime());
        }
        return null;
    }

    public String toTimeString() {
        if (this.getCalendar(false) != null) {
            return DateFormat.getTimeInstance(0, Locale.US).format(this.calendar.getTime());
        }
        return null;
    }

    public String toUTCString() {
        if (this.getUTC(false) != null) {
            return DateFormat.getDateTimeInstance(0, 0, Locale.US).format(this.utc.getTime());
        }
        return null;
    }

    public static double UTC(int year, int month, int day, int hours, int minutes, int seconds, int ms) {
        return new Date(year, month, day, hours, minutes, seconds, ms).getTime();
    }

    public double valueOf() {
        return this.getTime();
    }
}

