/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.javascript;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.stjs.javascript.SortFunction;
import org.stjs.javascript.annotation.ServerSide;
import org.stjs.javascript.annotation.Template;
import org.stjs.javascript.functions.Callback1;

public class Array<V>
implements Iterable<String> {
    private final List<V> array;

    public Array() {
        this(new ArrayList());
    }

    private Array(List<V> elements) {
        this.array = elements;
    }

    public Array(Number size) {
        this();
        this.$length(size.intValue());
    }

    public Array(V first, V second, V ... others) {
        this();
        this.push(first);
        this.push(second);
        this.push(others);
    }

    @ServerSide
    public static <T> Array<T> wrap(List<T> list) {
        return new Array<T>(list);
    }

    @ServerSide
    public static <T> Array<T> copyOf(List<T> list) {
        return new Array<T>(new ArrayList<T>(list));
    }

    @ServerSide
    public List<V> java() {
        return this.array;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int current = 0;

            @Override
            public boolean hasNext() {
                return this.current < Array.this.array.size();
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Integer.toString(this.current++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Template(value="get")
    public V $get(int index) {
        if (index < 0 || index >= this.array.size()) {
            return null;
        }
        return this.array.get(index);
    }

    @Template(value="get")
    public V $get(String index) {
        return this.$get(Integer.valueOf(index));
    }

    @Template(value="set")
    public void $set(int index, V value) {
        if (index < 0) {
            return;
        }
        if (index >= this.array.size()) {
            this.$length(index + 1);
        }
        this.array.set(index, value);
    }

    @Template(value="set")
    public void $set(String index, V value) {
        this.$set(Integer.valueOf(index), value);
    }

    @Template(value="toProperty")
    public int $length() {
        return this.array.size();
    }

    @Template(value="toProperty")
    public void $length(int newLength) {
        if (newLength < this.array.size()) {
            this.splice(newLength, this.array.size() - newLength);
        } else {
            while (this.array.size() < newLength) {
                this.array.add(null);
            }
        }
    }

    public Array<V> concat(Array<V> ... arrays) {
        Array<V> ret = new Array<V>();
        ret.array.addAll(this.array);
        for (Array<V> a : arrays) {
            for (int i = 0; i < a.$length(); ++i) {
                ret.array.add(a.$get(i));
            }
        }
        return ret;
    }

    public int indexOf(V element) {
        return this.array.indexOf(element);
    }

    public int indexOf(V element, int aStart) {
        int start;
        int n = start = aStart >= 0 ? aStart : this.array.size() + aStart;
        if (start >= this.array.size()) {
            return -1;
        }
        int pos = this.array.subList(start, this.array.size()).indexOf(element);
        if (pos < 0) {
            return pos;
        }
        return pos + start;
    }

    public String join() {
        return this.join(",");
    }

    public String join(String separator) {
        StringBuilder sb = new StringBuilder();
        for (V value : this.array) {
            if (sb.length() != 0) {
                sb.append(separator);
            }
            sb.append(value != null ? value.toString() : "");
        }
        return sb.toString();
    }

    public V pop() {
        if (this.array.size() == 0) {
            return null;
        }
        return this.array.remove(this.array.size() - 1);
    }

    public int push(V ... values) {
        for (V value : values) {
            this.array.add(value);
        }
        return this.array.size();
    }

    public Array<V> reverse() {
        Collections.reverse(this.array);
        return this;
    }

    public V shift() {
        if (this.array.size() == 0) {
            return null;
        }
        return this.array.remove(0);
    }

    private int fixIndex(int idx) {
        if (idx >= 0) {
            return Math.min(idx, this.array.size());
        }
        return Math.max(0, this.array.size() + idx);
    }

    public Array<V> slice(int start) {
        return this.slice(this.fixIndex(start), this.array.size());
    }

    public Array<V> slice(int start, int end) {
        int e;
        int s = this.fixIndex(start);
        if (s > (e = this.fixIndex(end))) {
            return new Array<V>();
        }
        Array<V> ret = new Array<V>();
        ret.array.addAll(this.array.subList(s, e));
        return ret;
    }

    public Array<V> splice(int start) {
        return this.splice(start, this.array.size() - start);
    }

    public Array<V> splice(int start, int howMany) {
        int s = this.fixIndex(start);
        Array<V> ret = new Array<V>();
        for (int i = 0; i < howMany && s < this.array.size(); ++i) {
            ret.array.add(this.array.remove(s));
        }
        return ret;
    }

    public Array<V> splice(int start, int howMany, V ... values) {
        int s = this.fixIndex(start);
        Array<V> removed = this.splice(start, howMany);
        this.array.addAll(s, Arrays.asList(values));
        return removed;
    }

    private SortFunction<V> defaultSortFunction() {
        return new SortFunction<V>(){

            @Override
            public int $invoke(V a, V b) {
                if (a == null) {
                    return 1;
                }
                if (b == null) {
                    return -1;
                }
                return a.toString().compareTo(b.toString());
            }
        };
    }

    public void sort() {
        this.sort(this.defaultSortFunction());
    }

    public void sort(SortFunction<V> aFunction) {
        final SortFunction<V> function = aFunction != null ? aFunction : this.defaultSortFunction();
        Collections.sort(this.array, new Comparator<V>(){

            @Override
            public int compare(V a, V b) {
                return function.$invoke(a, b);
            }
        });
    }

    public int unshift(V ... values) {
        this.array.addAll(0, Arrays.asList(values));
        return this.array.size();
    }

    @Override
    public void forEach(Callback1<V> callback) {
        for (V value : this.array) {
            callback.$invoke(value);
        }
    }

    @Template(value="prefix")
    public void $forEach(Callback1<V> callback) {
        this.forEach(callback);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (V item : this.array) {
            if (!first) {
                builder.append(",");
            } else {
                first = false;
            }
            if (item == null) {
                builder.append("null");
                continue;
            }
            builder.append(item.toString());
        }
        return builder.toString();
    }
}

