/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.logging;

import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.springaicommunity.mcp.annotation.McpLogging;
import org.springaicommunity.mcp.method.logging.SyncLoggingSpecification;
import org.springaicommunity.mcp.method.logging.SyncMcpLoggingMethodCallback;
import org.springaicommunity.mcp.provider.McpProviderUtils;

public class SyncMcpLoggingProvider {
    private final List<Object> loggingConsumerObjects;

    public SyncMcpLoggingProvider(List<Object> loggingConsumerObjects) {
        Assert.notNull(loggingConsumerObjects, (String)"loggingConsumerObjects cannot be null");
        this.loggingConsumerObjects = loggingConsumerObjects;
    }

    public List<SyncLoggingSpecification> getLoggingSpecifications() {
        List<SyncLoggingSpecification> loggingConsumers = this.loggingConsumerObjects.stream().map(consumerObject -> Stream.of(this.doGetClassMethods(consumerObject)).filter(method -> method.isAnnotationPresent(McpLogging.class)).filter(McpProviderUtils.filterReactiveReturnTypeMethod()).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).map(mcpLoggingConsumerMethod -> {
            McpLogging loggingConsumerAnnotation = mcpLoggingConsumerMethod.getAnnotation(McpLogging.class);
            SyncMcpLoggingMethodCallback methodCallback = ((SyncMcpLoggingMethodCallback.Builder)((SyncMcpLoggingMethodCallback.Builder)((SyncMcpLoggingMethodCallback.Builder)SyncMcpLoggingMethodCallback.builder().method((Method)mcpLoggingConsumerMethod)).bean(consumerObject)).loggingConsumer(loggingConsumerAnnotation)).build();
            return new SyncLoggingSpecification(loggingConsumerAnnotation.clients(), methodCallback);
        }).toList()).flatMap(Collection::stream).toList();
        return loggingConsumers;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }
}

