/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.complete;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.springaicommunity.mcp.adapter.CompleteAdapter;
import org.springaicommunity.mcp.annotation.McpComplete;
import org.springaicommunity.mcp.method.complete.SyncMcpCompleteMethodCallback;
import org.springaicommunity.mcp.provider.McpProviderUtils;

public class SyncMcpCompleteProvider {
    private final List<Object> completeObjects;

    public SyncMcpCompleteProvider(List<Object> completeObjects) {
        Assert.notNull(completeObjects, (String)"completeObjects cannot be null");
        this.completeObjects = completeObjects;
    }

    public List<McpServerFeatures.SyncCompletionSpecification> getCompleteSpecifications() {
        List<McpServerFeatures.SyncCompletionSpecification> syncCompleteSpecification = this.completeObjects.stream().map(completeObject -> Stream.of(this.doGetClassMethods(completeObject)).filter(method -> method.isAnnotationPresent(McpComplete.class)).filter(McpProviderUtils.filterReactiveReturnTypeMethod()).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).map(mcpCompleteMethod -> {
            McpComplete completeAnnotation = mcpCompleteMethod.getAnnotation(McpComplete.class);
            McpSchema.CompleteReference completeRef = CompleteAdapter.asCompleteReference(completeAnnotation, mcpCompleteMethod);
            SyncMcpCompleteMethodCallback methodCallback = ((SyncMcpCompleteMethodCallback.Builder)((SyncMcpCompleteMethodCallback.Builder)((SyncMcpCompleteMethodCallback.Builder)SyncMcpCompleteMethodCallback.builder().method((Method)mcpCompleteMethod)).bean(completeObject)).reference(completeRef)).build();
            return new McpServerFeatures.SyncCompletionSpecification(completeRef, (BiFunction)methodCallback);
        }).toList()).flatMap(Collection::stream).toList();
        return syncCompleteSpecification;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }
}

