/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.resource;

import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.List;
import org.springaicommunity.mcp.method.resource.AbstractMcpResourceMethodCallback;
import org.springaicommunity.mcp.method.resource.McpReadResourceResultConverter;

public class DefaultMcpReadResourceResultConverter
implements McpReadResourceResultConverter {
    private static final String DEFAULT_MIME_TYPE = "text/plain";

    @Override
    public McpSchema.ReadResourceResult convertToReadResourceResult(Object result, String requestUri, String mimeType, AbstractMcpResourceMethodCallback.ContentType contentType) {
        List<McpSchema.ResourceContents> contents;
        if (result == null) {
            return new McpSchema.ReadResourceResult(List.of());
        }
        if (result instanceof McpSchema.ReadResourceResult) {
            return (McpSchema.ReadResourceResult)result;
        }
        String string = mimeType = mimeType != null && !mimeType.isEmpty() ? mimeType : DEFAULT_MIME_TYPE;
        AbstractMcpResourceMethodCallback.ContentType contentType2 = contentType != null ? contentType : (contentType = this.isTextMimeType(mimeType) ? AbstractMcpResourceMethodCallback.ContentType.TEXT : AbstractMcpResourceMethodCallback.ContentType.BLOB);
        if (result instanceof List) {
            contents = this.convertListResult((List)result, requestUri, contentType, mimeType);
        } else if (result instanceof McpSchema.ResourceContents) {
            contents = List.of((McpSchema.ResourceContents)result);
        } else if (result instanceof String) {
            contents = this.convertStringResult((String)result, requestUri, contentType, mimeType);
        } else {
            throw new IllegalArgumentException("Unsupported return type: " + result.getClass().getName());
        }
        return new McpSchema.ReadResourceResult(contents);
    }

    private boolean isTextMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        if (mimeType.startsWith("text/")) {
            return true;
        }
        return mimeType.equals("application/json") || mimeType.equals("application/xml") || mimeType.equals("application/javascript") || mimeType.equals("application/ecmascript") || mimeType.equals("application/x-httpd-php") || mimeType.equals("application/xhtml+xml") || mimeType.endsWith("+json") || mimeType.endsWith("+xml");
    }

    private List<McpSchema.ResourceContents> convertListResult(List<?> list, String requestUri, AbstractMcpResourceMethodCallback.ContentType contentType, String mimeType) {
        if (list.isEmpty()) {
            return List.of();
        }
        McpSchema.ResourceContents firstItem = list.get(0);
        if (firstItem instanceof McpSchema.ResourceContents) {
            return list;
        }
        if (firstItem instanceof String) {
            List<McpSchema.ResourceContents> stringList = list;
            ArrayList<McpSchema.ResourceContents> result = new ArrayList<McpSchema.ResourceContents>(stringList.size());
            if (contentType == AbstractMcpResourceMethodCallback.ContentType.TEXT) {
                for (String string : stringList) {
                    result.add((McpSchema.ResourceContents)new McpSchema.TextResourceContents(requestUri, mimeType, string));
                }
            } else {
                for (String string : stringList) {
                    result.add((McpSchema.ResourceContents)new McpSchema.BlobResourceContents(requestUri, mimeType, string));
                }
            }
            return result;
        }
        throw new IllegalArgumentException("Unsupported list item type: " + firstItem.getClass().getName() + ". Expected String or ResourceContents.");
    }

    private List<McpSchema.ResourceContents> convertStringResult(String stringResult, String requestUri, AbstractMcpResourceMethodCallback.ContentType contentType, String mimeType) {
        if (contentType == AbstractMcpResourceMethodCallback.ContentType.TEXT) {
            return List.of(new McpSchema.TextResourceContents(requestUri, mimeType, stringResult));
        }
        return List.of(new McpSchema.BlobResourceContents(requestUri, mimeType, stringResult));
    }
}

