/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.resource;

import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.annotation.McpResource;
import org.springaicommunity.mcp.method.resource.AsyncStatelessMcpResourceMethodCallback;
import org.springaicommunity.mcp.provider.McpProviderUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AsyncStatelessMcpResourceProvider {
    private static final Logger logger = LoggerFactory.getLogger(AsyncStatelessMcpResourceProvider.class);
    private final List<Object> resourceObjects;

    public AsyncStatelessMcpResourceProvider(List<Object> resourceObjects) {
        Assert.notNull(resourceObjects, (String)"resourceObjects cannot be null");
        this.resourceObjects = resourceObjects;
    }

    public List<McpStatelessServerFeatures.AsyncResourceSpecification> getResourceSpecifications() {
        List<McpStatelessServerFeatures.AsyncResourceSpecification> resourceSpecs = this.resourceObjects.stream().map(resourceObject -> Stream.of(this.doGetClassMethods(resourceObject)).filter(method -> method.isAnnotationPresent(McpResource.class)).filter(method -> Mono.class.isAssignableFrom(method.getReturnType()) || Flux.class.isAssignableFrom(method.getReturnType()) || Publisher.class.isAssignableFrom(method.getReturnType())).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).map(mcpResourceMethod -> {
            McpResource resourceAnnotation = this.doGetMcpResourceAnnotation((Method)mcpResourceMethod);
            String uri = resourceAnnotation.uri();
            if (McpProviderUtils.isUriTemplate(uri)) {
                return null;
            }
            String name = AsyncStatelessMcpResourceProvider.getName(mcpResourceMethod, resourceAnnotation);
            String description = resourceAnnotation.description();
            String mimeType = resourceAnnotation.mimeType();
            McpSchema.Resource mcpResource = McpSchema.Resource.builder().uri(uri).name(name).description(description).mimeType(mimeType).build();
            AsyncStatelessMcpResourceMethodCallback methodCallback = ((AsyncStatelessMcpResourceMethodCallback.Builder)((AsyncStatelessMcpResourceMethodCallback.Builder)((AsyncStatelessMcpResourceMethodCallback.Builder)AsyncStatelessMcpResourceMethodCallback.builder().method((Method)mcpResourceMethod)).bean(resourceObject)).resource(mcpResource)).build();
            McpStatelessServerFeatures.AsyncResourceSpecification resourceSpec = new McpStatelessServerFeatures.AsyncResourceSpecification(mcpResource, (BiFunction)methodCallback);
            return resourceSpec;
        }).filter(Objects::nonNull).toList()).flatMap(Collection::stream).toList();
        if (resourceSpecs.isEmpty()) {
            logger.warn("No resource methods found in the provided resource objects: {}", this.resourceObjects);
        }
        return resourceSpecs;
    }

    public List<McpStatelessServerFeatures.AsyncResourceTemplateSpecification> getResourceTemplateSpecifications() {
        List<McpStatelessServerFeatures.AsyncResourceTemplateSpecification> resourceSpecs = this.resourceObjects.stream().map(resourceObject -> Stream.of(this.doGetClassMethods(resourceObject)).filter(method -> method.isAnnotationPresent(McpResource.class)).filter(method -> Mono.class.isAssignableFrom(method.getReturnType()) || Flux.class.isAssignableFrom(method.getReturnType()) || Publisher.class.isAssignableFrom(method.getReturnType())).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).map(mcpResourceMethod -> {
            McpResource resourceAnnotation = this.doGetMcpResourceAnnotation((Method)mcpResourceMethod);
            String uri = resourceAnnotation.uri();
            if (!McpProviderUtils.isUriTemplate(uri)) {
                return null;
            }
            String name = AsyncStatelessMcpResourceProvider.getName(mcpResourceMethod, resourceAnnotation);
            String description = resourceAnnotation.description();
            String mimeType = resourceAnnotation.mimeType();
            McpSchema.ResourceTemplate mcpResource = McpSchema.ResourceTemplate.builder().uriTemplate(uri).name(name).description(description).mimeType(mimeType).build();
            AsyncStatelessMcpResourceMethodCallback methodCallback = ((AsyncStatelessMcpResourceMethodCallback.Builder)((AsyncStatelessMcpResourceMethodCallback.Builder)((AsyncStatelessMcpResourceMethodCallback.Builder)AsyncStatelessMcpResourceMethodCallback.builder().method((Method)mcpResourceMethod)).bean(resourceObject)).resource(mcpResource)).build();
            McpStatelessServerFeatures.AsyncResourceTemplateSpecification resourceSpec = new McpStatelessServerFeatures.AsyncResourceTemplateSpecification(mcpResource, (BiFunction)methodCallback);
            return resourceSpec;
        }).filter(Objects::nonNull).toList()).flatMap(Collection::stream).toList();
        if (resourceSpecs.isEmpty()) {
            logger.warn("No resource methods found in the provided resource objects: {}", this.resourceObjects);
        }
        return resourceSpecs;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }

    protected McpResource doGetMcpResourceAnnotation(Method method) {
        return method.getAnnotation(McpResource.class);
    }

    private static String getName(Method method, McpResource resource) {
        Assert.notNull((Object)method, (String)"method cannot be null");
        if (resource == null || resource.name() == null || resource.name().isEmpty()) {
            return method.getName();
        }
        return resource.name();
    }
}

