/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website;

import com.google.inject.Inject;
import java.util.List;
import org.spincast.core.server.Server;
import org.spincast.shaded.org.apache.commons.lang3.tuple.Pair;
import org.spincast.website.AppConfig;

public class HttpAuthInit {
    private final AppConfig appConfig;
    private final Server server;

    @Inject
    public HttpAuthInit(AppConfig appConfig, Server server) {
        this.appConfig = appConfig;
        this.server = server;
    }

    protected AppConfig getAppConfig() {
        return this.appConfig;
    }

    protected Server getServer() {
        return this.server;
    }

    @Inject
    protected void init() {
        List<Pair<String, String>> adminUsernamesPasswords = this.getAppConfig().getAdminUsernamesPasswords();
        for (Pair<String, String> adminUsernamesPassword : adminUsernamesPasswords) {
            this.getServer().addHttpAuthentication("admin", adminUsernamesPassword.getKey(), adminUsernamesPassword.getValue());
        }
        this.getServer().addHttpAuthentication("protected example", "Stromgol", "Laroche");
    }
}

