/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website.maven;

import com.google.inject.Inject;
import java.io.File;
import java.io.FilenameFilter;
import org.spincast.core.guice.MainArgs;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.defaults.bootstrapping.Spincast;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.website.maven.SpincastMavenScriptBase;

public class SpincastMavenPreparePackage
extends SpincastMavenScriptBase {
    private final SpincastUtils spincastUtils;
    private String projectVersion;

    public static void main(String[] args) {
        Spincast.configure().init(args);
    }

    @Inject
    public SpincastMavenPreparePackage(@MainArgs String[] mainArgs, SpincastUtils spincastUtils) {
        super(mainArgs);
        this.spincastUtils = spincastUtils;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected String getProjectVersion() {
        if (this.projectVersion == null) {
            if (this.getMainArgs().length < 2) {
                this.sendException("The " + SpincastMavenPreparePackage.class.getName() + " class expect the version of the project to be passed as the second parameter: <argument>${project.version}</argument>");
            }
            this.projectVersion = this.getMainArgs()[1].trim();
        }
        return this.projectVersion;
    }

    @Override
    @Inject
    protected void init() {
        super.init();
        this.log("Starting 'prepare-package' phase Spincast script.");
        this.addQuickStartToWebsite();
        this.addDemoAppsToWebsite();
    }

    protected void addQuickStartToWebsite() {
        File quickStartProjectRoot = new File(this.getProjectBaseDir().getAbsolutePath() + "/../spincast-quickstart");
        File targetZipFile = new File(this.getProjectBuildOutputDir().getAbsolutePath() + "/public/quickstart/spincast-quick-start.zip");
        File targetZipFileSrc = new File(this.getProjectBaseDir().getAbsolutePath() + "/src/main/resources/public/quickstart/spincast-quick-start.zip");
        this.addAppToWebsite(quickStartProjectRoot, targetZipFile, targetZipFileSrc, "org.spincast", "spincast-quickstart", "1.0.0-SNAPSHOT");
    }

    protected void addDemoAppsToWebsite() {
        try {
            String[] appDirNames;
            this.log("Start adding the demo apps to the website.");
            File demoAppsRootDir = new File(this.getProjectBaseDir().getAbsolutePath() + "/demo-apps");
            if (!demoAppsRootDir.isDirectory()) {
                throw new RuntimeException("Root directory for demo apps not found : " + demoAppsRootDir.getAbsolutePath());
            }
            for (String appDirName : appDirNames = demoAppsRootDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File current, String name) {
                    return new File(current, name).isDirectory();
                }
            })) {
                File demoAppRootDir = new File(demoAppsRootDir + "/" + appDirName);
                if (!new File(demoAppRootDir.getAbsolutePath() + "/pom.xml").isFile()) continue;
                String artifactId = "spincast-demos-" + appDirName;
                String zipFileName = artifactId + ".zip";
                File targetZipFile = new File(this.getProjectBuildOutputDir().getAbsolutePath() + "/public/demo-apps/" + zipFileName);
                File targetZipFileSrc = new File(this.getProjectBaseDir().getAbsolutePath() + "/src/main/resources/public/demo-apps/" + zipFileName);
                this.addAppToWebsite(demoAppRootDir, targetZipFile, targetZipFileSrc, "org.spincast.demos", artifactId, this.getProjectVersion());
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected void addAppToWebsite(File appRootDir, File targetZipFile, File targetZipFileSrc, String groupId, String artifactId, String version) {
        try {
            File configFile;
            File gitIgnore;
            this.log("Start adding the app " + appRootDir + " to the website...");
            this.log("Replacing content in pom.xml...");
            File targetDir = new File(this.getProjectBuildDir().getAbsolutePath() + "/" + artifactId);
            FileUtils.copyDirectory(new File(appRootDir.getAbsolutePath() + "/src"), new File(targetDir.getAbsolutePath() + "/src"));
            File variaDir = new File(appRootDir.getAbsolutePath() + "/varia");
            if (variaDir.isDirectory()) {
                FileUtils.copyDirectory(variaDir, new File(targetDir.getAbsolutePath() + "/varia"));
            }
            File pomTarget = new File(targetDir.getAbsolutePath() + "/pom.xml");
            FileUtils.copyFile(new File(appRootDir.getAbsolutePath() + "/pom.xml"), pomTarget);
            File readme = new File(appRootDir.getAbsolutePath() + "/readme.md");
            File readmeTarget = new File(targetDir.getAbsolutePath() + "/readme.md");
            if (readme.isFile()) {
                FileUtils.copyFile(readme, readmeTarget);
            }
            if ((gitIgnore = new File(appRootDir.getAbsolutePath() + "/.gitignore")).isFile()) {
                FileUtils.copyFile(gitIgnore, new File(targetDir.getAbsolutePath() + "/.gitignore"));
            }
            if ((configFile = new File(appRootDir.getAbsolutePath() + "/app-config.yaml")).isFile()) {
                FileUtils.copyFile(configFile, new File(targetDir.getAbsolutePath() + "/app-config.yaml"));
            }
            String pomContent = FileUtils.readFileToString(pomTarget, "UTF-8");
            String projectVersion = this.getProjectVersion();
            pomContent = pomContent.replace("${project.version}", projectVersion);
            String cleanCoords = "<groupId>" + groupId + "</groupId>\n    <artifactId>" + artifactId + "</artifactId>\n    <version>" + version + "</version>";
            pomContent = pomContent.replaceAll("(?s)<!-- SPINCAST_COORDINATES -->.*<!-- /SPINCAST_COORDINATES -->", cleanCoords);
            pomContent = pomContent.replace("<!--$NO-MVN-MAN-VER$-->", "");
            String snapshotRepo = "";
            if (projectVersion.endsWith("-SNAPSHOT")) {
                snapshotRepo = "$1";
            }
            pomContent = pomContent.replaceAll("(?s)<!-- SPINCAST_SNAPSHOTS_REPO -->(.*)<!-- /SPINCAST_SNAPSHOTS_REPO -->", snapshotRepo);
            FileUtils.writeStringToFile(pomTarget, pomContent, "UTF-8");
            if (readme.isFile()) {
                String readmeContent = FileUtils.readFileToString(readmeTarget, "UTF-8");
                readmeContent = readmeContent.replace("${project.version}", projectVersion);
                FileUtils.writeStringToFile(readmeTarget, readmeContent, "UTF-8");
            }
            this.getSpincastUtils().zipDirectory(targetDir, targetZipFile, true);
            FileUtils.copyFile(targetZipFile, targetZipFileSrc);
            this.log("App .zip file generated and added to the website.");
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }
}

