/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import org.spincast.core.routing.ETag;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.commons.lang3.builder.EqualsBuilder;
import org.spincast.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;

public class ETagDefault
implements ETag {
    private final String tag;
    private final boolean isWeak;
    private final boolean isWildcard;
    private String headerValue = null;

    public ETagDefault(String tag) {
        this(tag, false, false);
    }

    public ETagDefault(String tag, boolean isWeak) {
        this(tag, isWeak, false);
    }

    public ETagDefault(String tag, boolean isWeak, boolean isWildcard) {
        if (StringUtils.isBlank(tag)) {
            if (!isWildcard) {
                throw new RuntimeException("The tag can't be empty for an ETag which is not a wildcard.");
            }
            tag = "*";
        }
        if (isWildcard && isWeak) {
            throw new RuntimeException("A wildcard ETag can't be weak!");
        }
        if (isWildcard && !StringUtils.isBlank(tag) && !"*".equals(tag)) {
            throw new RuntimeException("A wildcard ETag must have an empty tag ('*' is also accepted).");
        }
        if (tag.indexOf(34) > -1) {
            throw new RuntimeException("The tag can't contain '\"'.");
        }
        if (isWildcard) {
            tag = "*";
        }
        this.tag = tag;
        this.isWeak = isWeak;
        this.isWildcard = isWildcard;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public boolean isWeak() {
        return this.isWeak;
    }

    @Override
    public boolean isWildcard() {
        return this.isWildcard;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ETag)) {
            return false;
        }
        ETag other = (ETag)obj;
        return new EqualsBuilder().append(this.getTag(), other.getTag()).append(this.isWeak(), other.isWeak()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getTag()).append(this.isWeak()).toHashCode();
    }

    @Override
    public String getHeaderValue() {
        if (this.headerValue == null) {
            if (this.isWildcard()) {
                this.headerValue = "*";
            } else {
                StringBuilder builder = new StringBuilder();
                if (this.isWeak()) {
                    builder.append("W/");
                }
                builder.append('\"').append(this.getTag()).append('\"');
                this.headerValue = builder.toString();
            }
        }
        return this.headerValue;
    }

    @Override
    public boolean matches(ETag other) {
        return this.matches(other, false);
    }

    @Override
    public boolean matches(ETag other, boolean weakComparison) {
        if (this.isWildcard() || other != null && other.isWildcard()) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getTag().equals(other.getTag())) {
            return false;
        }
        return weakComparison || !this.isWeak() && !other.isWeak();
    }

    public String toString() {
        return this.getHeaderValue();
    }
}

