/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.json;

import com.google.inject.Inject;
import java.util.Objects;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.exceptions.CantConvertException;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.json.JsonObjectOrArray;
import org.spincast.core.json.JsonPathUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class JsonPathUtilsDefault
implements JsonPathUtils {
    private final SpincastConfig spincastConfig;
    private final JsonManager jsonManager;

    @Inject
    public JsonPathUtilsDefault(SpincastConfig spincastConfig, JsonManager jsonManager) {
        this.spincastConfig = spincastConfig;
        this.jsonManager = jsonManager;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected int getJsonPathArrayIndexMax() {
        return this.getSpincastConfig().getJsonPathArrayIndexMax();
    }

    protected int getKeyMaxLengthWhenConvertingMapToJsonObject() {
        return this.getSpincastConfig().getKeyMaxLengthWhenConvertingMapToJsonObject();
    }

    @Override
    public Object getElementAtJsonPath(JsonObject obj, String jsonPath) {
        return this.selectValueUsingJsonPath(obj, jsonPath, false, null);
    }

    @Override
    public Object getElementAtJsonPath(JsonObject obj, String jsonPath, Object defaultElement) {
        return this.selectValueUsingJsonPath(obj, jsonPath, true, defaultElement);
    }

    protected Object selectValueUsingJsonPath(JsonObject obj, String jsonPath, boolean hasDefaultValue, Object defaultElement) {
        return this.processJsonPath(obj, jsonPath, JsonPathProcessingType.GET, null, hasDefaultValue, defaultElement);
    }

    @Override
    public Object getElementAtJsonPath(JsonArray array, String jsonPath) {
        return this.selectValueUsingJsonPath(array, jsonPath, false, null);
    }

    @Override
    public Object getElementAtJsonPath(JsonArray array, String jsonPath, Object defaultElement) {
        return this.selectValueUsingJsonPath(array, jsonPath, true, defaultElement);
    }

    protected Object selectValueUsingJsonPath(JsonArray array, String jsonPath, boolean hasDefaultValue, Object defaultElement) {
        Objects.requireNonNull(array, "The array can't be NULL");
        JsonObject root = this.getJsonManager().create();
        root.setNoKeyParsing("array", array, false);
        jsonPath = "array" + jsonPath;
        Object result = this.selectValueUsingJsonPath(root, jsonPath, hasDefaultValue, defaultElement);
        return result;
    }

    @Override
    public void putElementAtJsonPath(JsonObjectOrArray root, String jsonPath, Object valueToAdd) {
        Objects.requireNonNull(root, "The root can't be NULL");
        JsonObject rootObj = null;
        if (root instanceof JsonObject) {
            rootObj = (JsonObject)root;
        } else if (root instanceof JsonArray) {
            if (jsonPath == null || !jsonPath.startsWith("[")) {
                throw new RuntimeException("The JsonPath from a JsonArray must start with the position of an element of the array inside brackets. For example : \"[2]\".");
            }
            jsonPath = "array" + jsonPath;
            rootObj = this.getJsonManager().create();
            rootObj.setNoKeyParsing("array", (JsonArray)root, false);
        } else {
            throw new RuntimeException("Not managed here : " + root);
        }
        this.processJsonPath(rootObj, jsonPath, JsonPathProcessingType.PUT, valueToAdd, false, null);
    }

    @Override
    public void removeElementAtJsonPath(JsonObject root, String jsonPath) {
        if (root == null) {
            return;
        }
        this.processJsonPath(root, jsonPath, JsonPathProcessingType.REMOVE, null, false, null);
    }

    @Override
    public void removeElementAtJsonPath(JsonArray array, String jsonPath) {
        if (array == null) {
            return;
        }
        JsonObject root = this.getJsonManager().create();
        root.setNoKeyParsing("a", array, false);
        jsonPath = "a" + jsonPath;
        this.removeElementAtJsonPath(root, jsonPath);
    }

    @Override
    public boolean isElementExists(JsonObject root, String jsonPath) {
        if (root == null || jsonPath == null) {
            return false;
        }
        Object result = this.processJsonPath(root, jsonPath, JsonPathProcessingType.EXISTS, null, false, null);
        if (!(result instanceof Boolean)) {
            throw new RuntimeException("Expecting a Boolean here! Got : " + result);
        }
        return (Boolean)result;
    }

    @Override
    public boolean isElementExists(JsonArray array, String jsonPath) {
        if (array == null || jsonPath == null) {
            return false;
        }
        JsonObject root = this.getJsonManager().create();
        root.setNoKeyParsing("a", array, false);
        jsonPath = "a" + jsonPath;
        return this.isElementExists(root, jsonPath);
    }

    protected Object processJsonPath(JsonObject root, String jsonPath, JsonPathProcessingType jsonPathProcessingType, Object valueToPut, boolean hasDefaultValue, Object defaultElement) {
        String token;
        Objects.requireNonNull(root, "The root object can't be NULL");
        if (jsonPath == null) {
            if (hasDefaultValue) {
                return defaultElement;
            }
            return null;
        }
        JsonObject currentObj = root;
        JsonArray currentArray = null;
        int currentArrayIndex = 0;
        if (!StringUtils.containsAny((CharSequence)jsonPath, (CharSequence)".[]")) {
            token = jsonPath;
        } else {
            if (jsonPath.length() > this.getKeyMaxLengthWhenConvertingMapToJsonObject()) {
                throw new RuntimeException("A JsonPath is too long to be parsed. This JsonPath starts with : " + jsonPath.substring(0, Math.min(30, jsonPath.length() - 1)));
            }
            StringBuilder tokenBuilder = new StringBuilder();
            if (jsonPath.startsWith(".")) {
                jsonPath = jsonPath.substring(1);
            }
            if (jsonPath.startsWith(".") || jsonPath.endsWith(".")) {
                throw new RuntimeException("JsonPath parsing error on character '.'. The JsonPath can't start or end with the '.' character. JsonPath : " + jsonPath);
            }
            if (jsonPath.endsWith("[")) {
                throw new RuntimeException("JsonPath parsing error on character '['. The JsonPath can't end with the '[' character. JsonPath : " + jsonPath);
            }
            if (jsonPath.startsWith("]")) {
                throw new RuntimeException("JsonPath parsing error on character '['. The JsonPath can't start with the ']' character. JsonPath : " + jsonPath);
            }
            boolean isInBrackets = false;
            boolean isInQuotes = false;
            boolean isInDoubleQuotes = false;
            char ch = '\u0000';
            char previousChar = '\u0000';
            for (int i = 0; i < jsonPath.length(); ++i) {
                previousChar = ch;
                ch = jsonPath.charAt(i);
                if (ch == '.') {
                    JsonObject obj;
                    if (isInQuotes || isInDoubleQuotes) {
                        tokenBuilder.append(ch);
                        continue;
                    }
                    if (isInBrackets) {
                        throw new RuntimeException("JsonPath parsing error on character '.'. A dot is not valid inside brackets but outside quotes. JsonPath : " + jsonPath);
                    }
                    if (currentObj != null) {
                        JsonObject obj2;
                        token = tokenBuilder.toString();
                        if ("".equals(token)) {
                            throw new RuntimeException("JsonPath parsing error on character '.'. A token is empty. JsonPath : " + jsonPath);
                        }
                        tokenBuilder = new StringBuilder();
                        try {
                            obj2 = currentObj.getJsonObjectNoKeyParsing(token);
                        }
                        catch (CantConvertException ex) {
                            throw new RuntimeException("JsonPath parsing error on character '.'. The key '" + token + "' already exists, but the associated value is not of type JsonObject as expected here. JsonPath : " + jsonPath);
                        }
                        if (obj2 == null) {
                            if (jsonPathProcessingType == JsonPathProcessingType.GET) {
                                if (hasDefaultValue) {
                                    return defaultElement;
                                }
                                return null;
                            }
                            if (jsonPathProcessingType == JsonPathProcessingType.EXISTS) {
                                return false;
                            }
                            obj2 = this.getJsonManager().create();
                            currentObj.set(token, obj2);
                        }
                        currentObj = obj2;
                        currentArray = null;
                        continue;
                    }
                    try {
                        obj = currentArray.getJsonObject(currentArrayIndex);
                    }
                    catch (CantConvertException ex) {
                        throw new RuntimeException("JsonPath parsing error on character '.'. The element of the array at index '" + currentArrayIndex + "' already exists, but is not of type JsonObject as expected here. JsonPath : " + jsonPath);
                    }
                    if (obj == null) {
                        if (jsonPathProcessingType == JsonPathProcessingType.GET) {
                            if (hasDefaultValue) {
                                return defaultElement;
                            }
                            return null;
                        }
                        if (jsonPathProcessingType == JsonPathProcessingType.EXISTS) {
                            return false;
                        }
                        obj = this.getJsonManager().create();
                        currentArray.set(currentArrayIndex, (Object)obj);
                    }
                    currentObj = obj;
                    currentArray = null;
                    continue;
                }
                if (ch == '[') {
                    if (isInQuotes || isInDoubleQuotes) {
                        tokenBuilder.append(ch);
                        continue;
                    }
                    if (isInBrackets) {
                        throw new RuntimeException("JsonPath parsing error on character '['.The '[' is not valid inside already started brackets. JsonPath : " + jsonPath);
                    }
                    token = tokenBuilder.toString();
                    tokenBuilder = new StringBuilder();
                    char nextChar = jsonPath.charAt(i + 1);
                    if (nextChar == '\"' || nextChar == '\'') {
                        JsonObject obj = null;
                        if (currentObj != null) {
                            if (i != 0) {
                                try {
                                    obj = currentObj.getJsonObject(token);
                                }
                                catch (CantConvertException ex) {
                                    throw new RuntimeException("JsonPath parsing error on character '['. The key '" + token + "' already exists, but the associated value is not of type JsonObject, as expected here. JsonPath : " + jsonPath);
                                }
                                if (obj == null) {
                                    if (jsonPathProcessingType == JsonPathProcessingType.GET) {
                                        if (hasDefaultValue) {
                                            return defaultElement;
                                        }
                                        return null;
                                    }
                                    if (jsonPathProcessingType == JsonPathProcessingType.EXISTS) {
                                        return false;
                                    }
                                    obj = this.getJsonManager().create();
                                    currentObj.set(token, obj);
                                }
                                currentObj = obj;
                                currentArray = null;
                            }
                        } else {
                            try {
                                obj = currentArray.getJsonObject(currentArrayIndex);
                            }
                            catch (CantConvertException ex) {
                                throw new RuntimeException("JsonPath parsing error on character '['. The index '" + currentArrayIndex + "' points to an already existing element, but not of type JsonObject. JsonPath : " + jsonPath);
                            }
                            if (obj == null) {
                                if (jsonPathProcessingType == JsonPathProcessingType.GET) {
                                    if (hasDefaultValue) {
                                        return defaultElement;
                                    }
                                    return null;
                                }
                                if (jsonPathProcessingType == JsonPathProcessingType.EXISTS) {
                                    return false;
                                }
                                obj = this.getJsonManager().create();
                                currentArray.set(currentArrayIndex, (Object)obj);
                            }
                            currentObj = obj;
                            currentArray = null;
                        }
                    } else {
                        JsonArray array;
                        if (currentObj != null) {
                            if (i == 0) {
                                throw new RuntimeException("JsonPath parsing error on character '['. The root object is not an array. JsonPath : " + jsonPath);
                            }
                            if ("".equals(token)) {
                                throw new RuntimeException("JsonPath parsing error on character '['. A token is empty . JsonPath : " + jsonPath);
                            }
                            try {
                                array = currentObj.getJsonArrayNoKeyParsing(token);
                            }
                            catch (CantConvertException ex) {
                                throw new RuntimeException("JsonPath parsing error on character '['. The key '" + token + "' points to an already existing element, but not of type JsonArray, as expected here. JsonPath : " + jsonPath);
                            }
                            if (array == null) {
                                if (jsonPathProcessingType == JsonPathProcessingType.GET) {
                                    if (hasDefaultValue) {
                                        return defaultElement;
                                    }
                                    return null;
                                }
                                if (jsonPathProcessingType == JsonPathProcessingType.EXISTS) {
                                    return false;
                                }
                                array = this.getJsonManager().createArray();
                                currentObj.set(token, array);
                            }
                        } else {
                            try {
                                array = currentArray.getJsonArray(currentArrayIndex);
                            }
                            catch (CantConvertException ex) {
                                throw new RuntimeException("JsonPath parsing error on character '['. The index '" + currentArrayIndex + "' points to an already existing element, but not of type JsonArray. JsonPath : " + jsonPath);
                            }
                            if (array == null) {
                                if (jsonPathProcessingType == JsonPathProcessingType.GET) {
                                    if (hasDefaultValue) {
                                        return defaultElement;
                                    }
                                    return null;
                                }
                                if (jsonPathProcessingType == JsonPathProcessingType.EXISTS) {
                                    return false;
                                }
                                array = this.getJsonManager().createArray();
                                currentArray.set(currentArrayIndex, (Object)array);
                            }
                        }
                        currentObj = null;
                        currentArray = array;
                    }
                    isInBrackets = true;
                    continue;
                }
                if (ch == ']') {
                    char nextChar;
                    if (isInQuotes || isInDoubleQuotes) {
                        tokenBuilder.append(ch);
                        continue;
                    }
                    if (!isInBrackets) {
                        throw new RuntimeException("JsonPath parsing error on character ']'. No start bracket found. JsonPath : " + jsonPath);
                    }
                    if (i < jsonPath.length() - 1 && (nextChar = jsonPath.charAt(i + 1)) != '.' && nextChar != '[') {
                        throw new RuntimeException("JsonPath parsing error on character ']'. The character following a ']', if any, must be '.' or '['. Here, the following character is '" + nextChar + "'. JsonPath : " + jsonPath);
                    }
                    token = tokenBuilder.toString();
                    if ("".equals(token)) {
                        throw new RuntimeException("JsonPath parsing error on character ']'. A key or an index was expected. JsonPath : " + jsonPath);
                    }
                    if (token.startsWith("\"") && token.endsWith("\"") || token.startsWith("'") && token.endsWith("'")) {
                        String key = token.substring(1, token.length() - 1);
                        if ("".equals(key)) {
                            throw new RuntimeException("JsonPath parsing error on character ']'. A key can't be empty. JsonPath : " + jsonPath);
                        }
                        tokenBuilder = new StringBuilder(key);
                    } else {
                        Integer index = null;
                        try {
                            index = Integer.parseInt(token);
                        }
                        catch (NumberFormatException ex) {
                            throw new RuntimeException("JsonPath parsing error on character ']'. The index '" + token + "' is not a valid integer. You have to use quotes or double-quotes for an object key, or a valid integer for an array index. JsonPath : " + jsonPath);
                        }
                        if (index < 0) {
                            throw new RuntimeException("JsonPath parsing error on character ']'. The index of an array can't be less than 0. JsonPath : " + jsonPath);
                        }
                        if (index > this.getJsonPathArrayIndexMax()) {
                            throw new RuntimeException("The index of an array is currently configured to have a maximum value of " + this.getJsonPathArrayIndexMax() + ". JsonPath : " + jsonPath);
                        }
                        if (currentArray == null) {
                            throw new RuntimeException("JsonPath parsing error on character ']'. Expecting a non-null array here. JsonPath : " + jsonPath);
                        }
                        currentArrayIndex = index;
                        tokenBuilder = new StringBuilder();
                    }
                    isInBrackets = false;
                    continue;
                }
                if (ch == '\"') {
                    if (isInBrackets && !isInQuotes && previousChar != '\\') {
                        isInDoubleQuotes = !isInDoubleQuotes;
                    }
                    tokenBuilder.append(ch);
                    continue;
                }
                if (ch == '\'') {
                    if (isInBrackets && !isInDoubleQuotes && previousChar != '\\') {
                        isInQuotes = !isInQuotes;
                    }
                    tokenBuilder.append(ch);
                    continue;
                }
                if (isInQuotes || isInDoubleQuotes) {
                    if (previousChar == '\\') {
                        if (ch != '\\') {
                            throw new RuntimeException("JsonPath parsing error on the '" + ch + "' character. This character can't be escaped. If you want to use a ''  inside a name, you need to escape it : \"\\\\\". JsonPath : " + jsonPath);
                        }
                        tokenBuilder.append(ch);
                        ch = '\u0000';
                        continue;
                    }
                    if (ch == '\\') {
                        continue;
                    }
                } else if (isInBrackets) {
                    if (ch < '0' || ch > '9') {
                        throw new RuntimeException("JsonPath parsing error on the '" + ch + "' character. Invalid character in the index, expecting a digit, got '" + ch + "'. JsonPath : " + jsonPath);
                    }
                } else if (ch == '.' || ch == '[' || ch == ']') {
                    throw new RuntimeException("The characters '.', '[' and ']' are not valid inside a object name or a property name, if this name is not in quotes. In JsonPath : " + jsonPath);
                }
                tokenBuilder.append(ch);
            }
            if (isInBrackets) {
                throw new RuntimeException("JsonPath parsing error on the last character. Some brackets were not closed properly. JsonPath : " + jsonPath);
            }
            token = tokenBuilder.toString();
        }
        if (currentObj != null) {
            if (jsonPathProcessingType == JsonPathProcessingType.PUT) {
                currentObj.setNoKeyParsing(token, valueToPut, false);
                return null;
            }
            if (jsonPathProcessingType == JsonPathProcessingType.GET) {
                if (hasDefaultValue) {
                    return currentObj.getObjectNoKeyParsing(token, defaultElement);
                }
                return currentObj.getObjectNoKeyParsing(token);
            }
            if (jsonPathProcessingType == JsonPathProcessingType.EXISTS) {
                return currentObj.isElementExistsNoKeyParsing(token);
            }
            if (jsonPathProcessingType == JsonPathProcessingType.REMOVE) {
                currentObj.removeNoKeyParsing(token);
                return null;
            }
            throw new RuntimeException("Unmanaged JsonPathProcessingType here : " + (Object)((Object)jsonPathProcessingType));
        }
        if (currentArray != null) {
            if (jsonPathProcessingType == JsonPathProcessingType.PUT) {
                currentArray.set(currentArrayIndex, valueToPut, false);
                return null;
            }
            if (jsonPathProcessingType == JsonPathProcessingType.GET) {
                if (hasDefaultValue) {
                    return currentArray.getObject(currentArrayIndex, defaultElement);
                }
                return currentArray.getObject(currentArrayIndex);
            }
            if (jsonPathProcessingType == JsonPathProcessingType.EXISTS) {
                return currentArray.isElementExists(currentArrayIndex);
            }
            if (jsonPathProcessingType == JsonPathProcessingType.REMOVE) {
                currentArray.remove(currentArrayIndex);
                return null;
            }
            throw new RuntimeException("Unmanaged JsonPathProcessingType here : " + (Object)((Object)jsonPathProcessingType));
        }
        throw new RuntimeException("Not supposed. Invalid parsing of JsonPath : " + jsonPath);
    }

    protected static enum JsonPathProcessingType {
        PUT,
        GET,
        REMOVE,
        EXISTS;

    }
}

